/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.core.gui.util.wrappers;

import com.gildedgames.util.ui.common.GuiFrame;
import com.gildedgames.util.ui.data.rect.Rect;
import com.gildedgames.util.ui.graphics.Graphics2D;
import com.gildedgames.util.ui.input.InputProvider;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class MinecraftTextBackground
extends GuiFrame {
    private int backColor = -267386864;
    private int borderColor = 0x505000FF;

    public MinecraftTextBackground(Rect rect) {
        super(rect);
    }

    public MinecraftTextBackground(Rect rect, int backColor, int borderColor) {
        this(rect);
        this.backColor = backColor;
        this.borderColor = borderColor;
    }

    public int getBackColor() {
        return this.backColor;
    }

    public void setBackColor(int backColor) {
        this.backColor = backColor;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
    }

    @Override
    public void draw(Graphics2D graphics, InputProvider input) {
        super.draw(graphics, input);
        GL11.glPushMatrix();
        this.drawTextBackground(this.dim().x() + 3.0f, this.dim().y() + 3.0f, this.dim().width() - 6.0f, this.dim().height() - 7.0f);
        GL11.glPopMatrix();
    }

    private void drawTextBackground(float cornerX, float cornerY, float width, float height) {
        int l1 = this.backColor;
        this.drawGradientRect(cornerX - 3.0f, cornerY - 4.0f, cornerX + width + 3.0f, cornerY - 3.0f, l1, l1);
        this.drawGradientRect(cornerX - 3.0f, cornerY + height + 3.0f, cornerX + width + 3.0f, cornerY + height + 4.0f, l1, l1);
        this.drawGradientRect(cornerX - 3.0f, cornerY - 3.0f, cornerX + width + 3.0f, cornerY + height + 3.0f, l1, l1);
        this.drawGradientRect(cornerX - 4.0f, cornerY - 3.0f, cornerX - 3.0f, cornerY + height + 3.0f, l1, l1);
        this.drawGradientRect(cornerX + width + 3.0f, cornerY - 3.0f, cornerX + width + 4.0f, cornerY + height + 3.0f, l1, l1);
        int i2 = this.borderColor;
        int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
        this.drawGradientRect(cornerX - 3.0f, cornerY - 3.0f + 1.0f, cornerX - 3.0f + 1.0f, cornerY + height + 3.0f - 1.0f, i2, j2);
        this.drawGradientRect(cornerX + width + 2.0f, cornerY - 3.0f + 1.0f, cornerX + width + 3.0f, cornerY + height + 3.0f - 1.0f, i2, j2);
        this.drawGradientRect(cornerX - 3.0f, cornerY - 3.0f, cornerX + width + 3.0f, cornerY - 3.0f + 1.0f, i2, i2);
        this.drawGradientRect(cornerX - 3.0f, cornerY + height + 2.0f, cornerX + width + 3.0f, cornerY + height + 3.0f, j2, j2);
    }

    public void drawGradientRect(float minX, float minY, float maxX, float maxY, int par5, int par6) {
        boolean zLevel = false;
        GL11.glPushMatrix();
        float f = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(par5 & 0xFF) / 255.0f;
        float f4 = (float)(par6 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(par6 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(par6 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(par6 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(f1, f2, f3, f);
        tessellator.func_78377_a((double)maxX, (double)minY, (double)zLevel);
        tessellator.func_78377_a((double)minX, (double)minY, (double)zLevel);
        tessellator.func_78369_a(f5, f6, f7, f4);
        tessellator.func_78377_a((double)minX, (double)maxY, (double)zLevel);
        tessellator.func_78377_a((double)maxX, (double)maxY, (double)zLevel);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }
}

