/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.core.gui.viewing;

import com.gildedgames.util.ui.data.AssetLocation;
import com.gildedgames.util.ui.data.DrawingData;
import com.gildedgames.util.ui.data.rect.Rect;
import com.gildedgames.util.ui.graphics.Graphics2D;
import com.gildedgames.util.ui.graphics.Sprite;
import com.gildedgames.util.ui.graphics.UVBehavior;
import com.gildedgames.util.ui.util.rect.RectCollection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class MinecraftGraphics2D
implements Graphics2D {
    protected Minecraft minecraft;
    protected Gui gui = new Gui();
    protected FontRenderer fontRenderer;
    protected float zLevel;

    public MinecraftGraphics2D(Minecraft minecraft) {
        this.minecraft = minecraft;
        this.fontRenderer = this.minecraft.field_71466_p;
    }

    private ResourceLocation convert(AssetLocation resource) {
        return new ResourceLocation(resource.getDomain(), resource.getPath());
    }

    private void draw(Rect dim, DrawingData data, DrawInner inner) {
        GL11.glPushMatrix();
        float currentX = dim.x();
        float currentY = dim.y();
        float x = currentX;
        float y = currentY;
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)dim.scale(), (float)dim.scale(), (float)0.0f);
        GL11.glTranslatef((float)(dim.width() / 2.0f + dim.originX()), (float)(dim.height() / 2.0f + dim.originY()), (float)-2000.0f);
        GL11.glRotatef((float)dim.degrees(), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-(dim.width() / 2.0f) - dim.originX()), (float)(-(dim.height() / 2.0f) - dim.originY()), (float)-2000.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)data.getAlpha());
        GL11.glEnable((int)3008);
        GL11.glEnable((int)6406);
        inner.draw();
        GL11.glDisable((int)3008);
        GL11.glDisable((int)6406);
        GL11.glPopMatrix();
    }

    @Override
    public void drawSprite(Sprite sprite, Rect dim, DrawingData data) {
        this.draw(dim, data, new DrawSprite(this, sprite, data, dim));
    }

    @Override
    public void drawText(String text, Rect dim, DrawingData data) {
        this.draw(dim, data, new DrawText(this.fontRenderer, text, dim, data));
    }

    @Override
    public void drawLine(int startX, int startY, int endX, int endY, DrawingData drawingData) {
    }

    @Override
    public void drawRectangle(Rect dim, DrawingData data) {
        this.draw(dim, data, new DrawRectangle(this, dim, data));
    }

    @Override
    public void drawGradientRectangle(Rect dim, DrawingData startColor, DrawingData endColor) {
        this.draw(dim, startColor, new DrawGradientRectangle(this, dim, startColor, endColor));
    }

    protected void drawGradientRect(double left, double top, double right, double bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(f1, f2, f3, f);
        tessellator.func_78377_a(right, top, (double)this.zLevel);
        tessellator.func_78377_a(left, top, (double)this.zLevel);
        tessellator.func_78369_a(f5, f6, f7, f4);
        tessellator.func_78377_a(left, bottom, (double)this.zLevel);
        tessellator.func_78377_a(right, bottom, (double)this.zLevel);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    private void drawModalRectWithCustomSizedTexture(double x, double y, double u, double v, double width, double height, double textureWidth, double textureHeight) {
        double f4 = 1.0 / textureWidth;
        double f5 = 1.0 / textureHeight;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x, y + height, 0.0, u * f4, (v + (double)((float)height)) * f5);
        tessellator.func_78374_a(x + width, y + height, 0.0, (u + (double)((float)width)) * f4, (v + (double)((float)height)) * f5);
        tessellator.func_78374_a(x + width, y, 0.0, (u + (double)((float)width)) * f4, v * f5);
        tessellator.func_78374_a(x, y, 0.0, u * f4, v * f5);
        tessellator.func_78381_a();
    }

    private void drawRect(double left, double top, double right, double bottom, int color) {
        double j1;
        if (left < right) {
            j1 = left;
            left = right;
            right = j1;
        }
        if (top < bottom) {
            j1 = top;
            top = bottom;
            bottom = j1;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)f, (float)f1, (float)f2, (float)f3);
        tessellator.func_78382_b();
        tessellator.func_78377_a(left, bottom, 0.0);
        tessellator.func_78377_a(right, bottom, 0.0);
        tessellator.func_78377_a(right, top, 0.0);
        tessellator.func_78377_a(left, top, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private static class DrawGradientRectangle
    implements DrawInner {
        private final MinecraftGraphics2D graphics;
        private final Rect dim;
        private final DrawingData startColor;
        private final DrawingData endColor;

        public DrawGradientRectangle(MinecraftGraphics2D graphics, Rect dim, DrawingData startColor, DrawingData endColor) {
            this.graphics = graphics;
            this.dim = dim;
            this.startColor = startColor;
            this.endColor = endColor;
        }

        @Override
        public void draw() {
            this.graphics.drawGradientRect(0.0, 0.0, this.dim.width(), this.dim.height(), this.startColor.getColor().getRGB(), this.endColor.getColor().getRGB());
        }
    }

    private static class DrawRectangle
    implements DrawInner {
        private final MinecraftGraphics2D graphics;
        private final Rect dim;
        private final DrawingData data;

        public DrawRectangle(MinecraftGraphics2D graphics, Rect dim, DrawingData data) {
            this.graphics = graphics;
            this.dim = dim;
            this.data = data;
        }

        @Override
        public void draw() {
            this.graphics.drawRect(0.0, 0.0, this.dim.width(), this.dim.height(), this.data.getColor().getRGB());
        }
    }

    private static class DrawText
    implements DrawInner {
        private final FontRenderer fontRenderer;
        private final String text;
        private final Rect dim;
        private final DrawingData data;

        public DrawText(FontRenderer fontRenderer, String text, Rect dim, DrawingData data) {
            this.fontRenderer = fontRenderer;
            this.text = text;
            this.dim = dim;
            this.data = data;
        }

        @Override
        public void draw() {
            this.fontRenderer.func_78261_a(this.text, 0, 0, this.data.getColor().getRGB());
        }
    }

    private static class DrawSprite
    implements DrawInner {
        private final MinecraftGraphics2D graphics;
        private final Sprite sprite;
        private final Rect dim;
        private final DrawingData data;
        private final RectCollection collection;

        public DrawSprite(MinecraftGraphics2D graphics, Sprite sprite, DrawingData data, Rect dim) {
            this.graphics = graphics;
            this.sprite = sprite;
            this.dim = dim;
            this.data = data;
            this.collection = RectCollection.flush(this.dim);
        }

        @Override
        public void draw() {
            this.graphics.minecraft.field_71446_o.func_110577_a(this.graphics.convert(this.sprite.getAsset()));
            if (this.sprite.getBehavior().shouldRecalculateUVs(this.sprite, this.collection)) {
                this.sprite.getBehavior().recalculateUVs(this.sprite, this.collection);
            }
            List<UVBehavior.UVDimPair> uvDimPairs = this.sprite.getBehavior().getDrawnUVsFor(this.sprite, this.collection);
            for (UVBehavior.UVDimPair uvDimPair : uvDimPairs) {
                Sprite.UV uv = uvDimPair.getUV();
                Rect dim = uvDimPair.getRect();
                this.graphics.drawModalRectWithCustomSizedTexture(dim.x(), dim.y(), uv.minU(), uv.minV(), uv.width(), uv.height(), this.sprite.getAssetWidth(), this.sprite.getAssetHeight());
            }
        }
    }

    private static interface DrawInner {
        public void draw();
    }
}

