/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.core.gui.viewing;

import com.gildedgames.util.ui.data.rect.Rect;
import com.gildedgames.util.ui.data.rect.RectHolder;
import com.gildedgames.util.ui.input.InputProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.MathHelper;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;

public class MinecraftInputProvider
implements InputProvider {
    protected Minecraft mc;
    protected float screenWidth;
    protected float screenHeight;
    protected float scaleFactor;
    protected float xOffset;
    protected float yOffset;
    protected ScaledResolution resolution;

    public MinecraftInputProvider(Minecraft mc) {
        this.mc = mc;
        this.refreshResolution();
    }

    public void setScreen(float screenWidth, float screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    public void setScaleFactor(float scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    @Override
    public void refreshResolution() {
        this.resolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
    }

    @Override
    public float getScreenWidth() {
        this.refreshResolution();
        return this.resolution.func_78326_a();
    }

    @Override
    public float getScreenHeight() {
        this.refreshResolution();
        return this.resolution.func_78328_b();
    }

    @Override
    public float getMouseX() {
        return (float)Mouse.getX() * this.getScreenWidth() / (float)this.mc.field_71443_c - this.xOffset;
    }

    @Override
    public float getMouseY() {
        return this.getScreenHeight() - (float)Mouse.getY() * this.getScreenHeight() / (float)this.mc.field_71440_d - 1.0f - this.yOffset;
    }

    @Override
    public boolean isHovered(Rect dim) {
        if (dim == null) {
            return false;
        }
        return this.getMouseX() >= dim.x() && this.getMouseY() >= dim.y() && this.getMouseX() < dim.x() + dim.width() && this.getMouseY() < dim.y() + dim.height();
    }

    @Override
    public float getScaleFactor() {
        return this.resolution.func_78325_e();
    }

    @Override
    public InputProvider copyWithMouseXOffset(float xOffset) {
        MinecraftInputProvider input = (MinecraftInputProvider)this.clone();
        input.xOffset = xOffset;
        return input;
    }

    @Override
    public InputProvider copyWithMouseYOffset(float yOffset) {
        MinecraftInputProvider input = (MinecraftInputProvider)this.clone();
        input.yOffset = yOffset;
        return input;
    }

    @Override
    public InputProvider clone() {
        MinecraftInputProvider input = new MinecraftInputProvider(this.mc);
        input.screenWidth = this.screenWidth;
        input.screenHeight = this.screenHeight;
        input.scaleFactor = this.scaleFactor;
        input.xOffset = this.xOffset;
        input.yOffset = this.yOffset;
        return input;
    }

    @Override
    public boolean isHovered(RectHolder holder) {
        if (holder == null) {
            return false;
        }
        return this.isHovered(holder.dim());
    }

    @Override
    public void setMouseX(float x) {
        Mouse.setCursorPosition((int)MathHelper.func_76141_d((float)(x / this.getScreenWidth() * (float)this.mc.field_71443_c)), (int)Mouse.getY());
    }

    @Override
    public void setMouseY(float y) {
        Mouse.setCursorPosition((int)Mouse.getX(), (int)(Display.getHeight() - MathHelper.func_76141_d((float)(y / this.getScreenHeight() * (float)this.mc.field_71440_d + 1.0f))));
    }

    @Override
    public void setMouse(float x, float y) {
        this.setMouseX(x);
        this.setMouseY(y);
    }
}

