/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.core.io;

import com.gildedgames.util.io_manager.IOCore;
import com.gildedgames.util.io_manager.constructor.IConstructor;
import com.gildedgames.util.io_manager.factory.IOBridge;
import com.gildedgames.util.io_manager.factory.IOFactory;
import com.gildedgames.util.io_manager.factory.IOObserver;
import com.gildedgames.util.io_manager.io.IO;
import com.gildedgames.util.io_manager.overhead.IOManager;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.List;

public class ByteBufBridge
implements IOBridge {
    protected ByteBuf buf;
    public static final ByteBufBridgeFactory factory = new ByteBufBridgeFactory();

    public ByteBufBridge(ByteBuf buf) {
        this.buf = buf;
    }

    @Override
    public byte[] getBytes() {
        return this.buf.array();
    }

    @Override
    public Class<?> getSerializedClass(String key) {
        String registryID = this.getString("");
        int classID = this.getInteger("");
        IOManager manager = IOCore.io().getManager(registryID);
        return manager.getRegistry().getClass(registryID, classID);
    }

    @Override
    public void setSerializedClass(String key, Class<?> classToWrite) {
        IOManager manager = IOCore.io().getManager(classToWrite);
        int classID = manager.getRegistry().getID(classToWrite);
        this.setString("", manager.getID());
        this.setInteger("", classID);
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.buf.writeBoolean(value);
    }

    @Override
    public void setByte(String key, byte value) {
        this.buf.writeByte((int)value);
    }

    @Override
    public void setShort(String key, short value) {
        this.buf.writeShort((int)value);
    }

    @Override
    public void setInteger(String key, int value) {
        this.buf.writeInt(value);
    }

    @Override
    public void setLong(String key, long value) {
        this.buf.writeLong(value);
    }

    @Override
    public void setFloat(String key, float value) {
        this.buf.writeFloat(value);
    }

    @Override
    public void setDouble(String key, double value) {
        this.buf.writeDouble(value);
    }

    @Override
    public void setString(String key, String value) {
        ByteBufUtils.writeUTF8String((ByteBuf)this.buf, (String)value);
    }

    @Override
    public void setByteArray(String key, byte[] array) {
        if (array == null) {
            this.buf.writeBoolean(false);
            return;
        }
        this.buf.writeBoolean(true);
        this.buf.writeInt(array.length);
        this.buf.writeBytes(array);
    }

    @Override
    public void setIO(String key, IO<IOBridge, IOBridge> io) {
        this.buf.writeBoolean(io != null);
        if (io != null) {
            IOCore.io().set("", this, factory, io);
        }
    }

    @Override
    public byte getByte(String key) {
        return this.buf.readByte();
    }

    @Override
    public short getShort(String key) {
        return this.buf.readShort();
    }

    @Override
    public int getInteger(String key) {
        return this.buf.readInt();
    }

    @Override
    public long getLong(String key) {
        return this.buf.readLong();
    }

    @Override
    public float getFloat(String key) {
        return this.buf.readFloat();
    }

    @Override
    public double getDouble(String key) {
        return this.buf.readDouble();
    }

    @Override
    public String getString(String key) {
        return ByteBufUtils.readUTF8String((ByteBuf)this.buf);
    }

    @Override
    public byte[] getByteArray(String key) {
        if (!this.buf.readBoolean()) {
            return null;
        }
        int amount = this.buf.readInt();
        byte[] bytes = new byte[amount];
        this.buf.readBytes(bytes);
        return bytes;
    }

    @Override
    public boolean getBoolean(String key) {
        return this.buf.readBoolean();
    }

    @Override
    public <T extends IO<IOBridge, IOBridge>> T getIO(String key) {
        if (this.buf.readBoolean()) {
            return IOCore.io().get("", this, factory, new IConstructor[0]);
        }
        return null;
    }

    public static class ByteBufBridgeFactory
    implements IOFactory<IOBridge, IOBridge> {
        @Override
        public IOBridge createInput(byte[] reading) {
            return new ByteBufBridge(Unpooled.copiedBuffer((byte[])reading));
        }

        @Override
        public IOBridge createOutput() {
            return new ByteBufBridge(Unpooled.buffer());
        }

        @Override
        public IOBridge createInputBridge(IOBridge input) {
            return input;
        }

        @Override
        public IOBridge createOutputBridge(IOBridge output) {
            return output;
        }

        @Override
        public List<IOObserver<IOBridge, IOBridge>> getObservers() {
            return Collections.emptyList();
        }
    }
}

