/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.core.io;

import com.gildedgames.util.io_manager.IOCore;
import com.gildedgames.util.io_manager.io.IOSyncable;
import com.gildedgames.util.io_manager.io.IOSyncableDispatcher;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;

public class MessageSyncToClient
implements IMessage {
    public IOSyncableDispatcher<ByteBuf, ByteBuf> dispatcher;
    public IOSyncable<ByteBuf, ByteBuf> syncable;
    public ByteBuf buf;

    public MessageSyncToClient() {
    }

    public MessageSyncToClient(IOSyncableDispatcher<ByteBuf, ByteBuf> dispatcher, IOSyncable<ByteBuf, ByteBuf> syncable) {
        this.dispatcher = dispatcher;
        this.syncable = syncable;
    }

    public void fromBytes(ByteBuf buf) {
        this.buf = buf;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.dispatcher.getID());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.dispatcher.getKey(this.syncable, IOSyncable.SyncSide.CLIENT));
        this.syncable.syncTo(buf, IOSyncable.SyncSide.CLIENT);
    }

    public static class Handler
    implements IMessageHandler<MessageSyncToClient, IMessage> {
        public IMessage onMessage(MessageSyncToClient message, MessageContext ctx) {
            if (ctx.side.isClient()) {
                String dispatcherID = ByteBufUtils.readUTF8String((ByteBuf)message.buf);
                String syncableID = ByteBufUtils.readUTF8String((ByteBuf)message.buf);
                IOSyncableDispatcher dispatcher = IOCore.io().getDispatcherFromID(dispatcherID);
                IOSyncable syncable = dispatcher.getSyncable(syncableID, IOSyncable.SyncSide.SERVER);
                syncable.syncFrom(message.buf, IOSyncable.SyncSide.SERVER);
            }
            return null;
        }
    }
}

