/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.core.io;

import com.gildedgames.util.io_manager.IOCore;
import com.gildedgames.util.io_manager.io.IOSyncable;
import com.gildedgames.util.io_manager.io.IOSyncableDispatcher;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;

public class MessageSyncToServer
implements IMessage {
    public IOSyncableDispatcher<ByteBuf, ByteBuf> dispatcher;
    public IOSyncable<ByteBuf, ByteBuf> syncable;
    public ByteBuf buf;

    public MessageSyncToServer() {
    }

    public MessageSyncToServer(IOSyncableDispatcher<ByteBuf, ByteBuf> dispatcher, IOSyncable<ByteBuf, ByteBuf> syncable) {
        this.dispatcher = dispatcher;
        this.syncable = syncable;
    }

    public void fromBytes(ByteBuf buf) {
        this.buf = buf;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.dispatcher.getID());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.dispatcher.getKey(this.syncable, IOSyncable.SyncSide.SERVER));
        this.syncable.syncTo(buf, IOSyncable.SyncSide.SERVER);
    }

    public static class Handler
    implements IMessageHandler<MessageSyncToServer, IMessage> {
        public IMessage onMessage(MessageSyncToServer message, MessageContext ctx) {
            if (ctx.side.isServer()) {
                String dispatcherID = ByteBufUtils.readUTF8String((ByteBuf)message.buf);
                String syncableID = ByteBufUtils.readUTF8String((ByteBuf)message.buf);
                IOSyncableDispatcher dispatcher = IOCore.io().getDispatcherFromID(dispatcherID);
                IOSyncable syncable = dispatcher.getSyncable(syncableID, IOSyncable.SyncSide.CLIENT);
                syncable.syncFrom(message.buf, IOSyncable.SyncSide.CLIENT);
            }
            return null;
        }
    }
}

