/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.core.nbt;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;

public class NBTHelper {
    public static NBTTagCompound readInputNBT(DataInputStream input) throws IOException {
        if (input.readBoolean()) {
            return CompressedStreamTools.func_74794_a((DataInputStream)input);
        }
        return null;
    }

    public static void writeOutputNBT(NBTTagCompound tag, DataOutputStream output) throws IOException {
        if (tag == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)output);
        }
    }

    public static void save(String fileName, NBTTagCompound tag) {
        File file = new File(NBTHelper.getWorldFolderPath(), fileName);
        NBTHelper.save(file, tag);
    }

    public static NBTTagCompound load(String fileName) {
        File file = new File(NBTHelper.getWorldFolderPath(), fileName);
        if (!file.exists()) {
            return new NBTTagCompound();
        }
        return NBTHelper.load(file);
    }

    private static String getWorldFolderPath() {
        if (MinecraftServer.func_71276_C() != null && MinecraftServer.func_71276_C().field_71305_c != null && MinecraftServer.func_71276_C().field_71305_c[0] != null) {
            return MinecraftServer.func_71276_C().field_71305_c[0].func_72860_G().func_75758_b(MinecraftServer.func_71276_C().func_71270_I()).getAbsolutePath().replace(MinecraftServer.func_71276_C().func_71270_I() + ".dat", "");
        }
        return null;
    }

    public static void save(File file, NBTTagCompound tag) {
        try {
            File directoryFile = file.getParentFile();
            directoryFile.mkdirs();
            file.createNewFile();
            FileOutputStream outputStream = new FileOutputStream(file);
            CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)outputStream);
            outputStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static NBTTagCompound load(File file) {
        try {
            FileInputStream inputStream = new FileInputStream(file);
            NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)inputStream);
            inputStream.close();
            return tag;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static byte[] fromTag(NBTTagCompound tag) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream stream = new DataOutputStream(byteStream);
        try {
            NBTHelper.writeOutputNBT(tag, stream);
            byte[] bytez = byteStream.toByteArray();
            stream.close();
            return bytez;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static NBTTagList encodeStackList(ItemStack[] stackList) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < stackList.length; ++i) {
            if (stackList[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            stackList[i].func_77955_b(nbttagcompound);
            tagList.func_74742_a((NBTBase)nbttagcompound);
        }
        return tagList;
    }

    public static ItemStack[] decodeStackList(NBTTagList tagList) {
        ItemStack[] stackList = new ItemStack[8];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = tagList.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
            if (itemstack == null || j < 0 || j >= stackList.length) continue;
            stackList[j] = itemstack;
        }
        return stackList;
    }
}

