/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.core.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class FixedStack<E>
implements Collection<E> {
    private int maxSize;
    private int size = 0;
    private int maxIndex = -1;
    private Object[] elementData;

    public FixedStack(int maxSize) {
        this.maxSize = maxSize;
        this.elementData = new Object[maxSize];
    }

    public int maxSize() {
        return this.maxSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        for (Object o2 : this.elementData) {
            if (o != o2) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return null;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elementData, this.size);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return null;
    }

    @Override
    public boolean add(E e) {
        ++this.maxIndex;
        if (this.maxIndex >= this.maxSize) {
            this.maxIndex = 0;
        }
        if (this.size < this.maxSize) {
            ++this.size;
        }
        this.elementData[this.maxIndex] = e;
        return true;
    }

    public E pop() {
        if (this.size <= 0) {
            return null;
        }
        Object toPop = this.elementData[this.maxIndex];
        this.elementData[this.maxIndex] = null;
        --this.size;
        --this.maxIndex;
        if (this.maxIndex < 0 && this.size > 0) {
            this.maxIndex = this.maxSize - 1;
        }
        return (E)toPop;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        block0: for (Object o : c) {
            for (Object o2 : this.elementData) {
                if (o == o2) continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E o : c) {
            this.add(o);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.maxSize; ++i) {
            this.elementData[i] = null;
        }
        this.size = 0;
        this.maxIndex = -1;
    }

    public void setMaxSize(int newSize) {
        if (newSize == this.maxSize) {
            return;
        }
        if (this.maxSize < newSize) {
            int i;
            Object[] copy = new Object[newSize];
            int index = 0;
            for (i = this.maxIndex + 1; i < this.maxSize; ++i) {
                copy[index] = this.elementData[i];
                ++index;
            }
            for (i = 0; i <= this.maxIndex; ++i) {
                copy[index] = this.elementData[i];
                ++index;
            }
            this.maxIndex = this.maxSize - 1;
            this.elementData = copy;
        } else {
            int i;
            Object[] copy = new Object[newSize];
            int index = newSize - 1;
            for (i = this.maxIndex; i >= 0 && index >= 0; --index, --i) {
                copy[index] = this.elementData[i];
            }
            for (i = this.maxSize - 1; i > this.maxIndex && index >= 0; --index, --i) {
                copy[index] = this.elementData[i];
            }
        }
        this.maxSize = newSize;
    }
}

