/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.core.util;

import com.gildedgames.util.core.UtilCore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class GGHelper {
    public static NBTTagCompound readNBTFromFile(String fileName) {
        return GGHelper.readNBTFromFile(new File(UtilCore.getWorldDirectory(), fileName));
    }

    public static NBTTagCompound readNBTFromFile(File file) {
        try {
            if (!file.exists()) {
                return null;
            }
            FileInputStream inputStream = new FileInputStream(file);
            return CompressedStreamTools.func_74796_a((InputStream)inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeNBTToFile(NBTTagCompound tag, String fileName) {
        GGHelper.writeNBTToFile(tag, new File(UtilCore.getWorldDirectory(), fileName));
    }

    public static void writeNBTToFile(NBTTagCompound tag, File file) {
        file.mkdirs();
        File tmpFile = new File(file.getParentFile(), file.getName() + ".tmp");
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)new FileOutputStream(tmpFile));
            if (file.exists()) {
                file.delete();
            }
            tmpFile.renameTo(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

