/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.player;

import com.gildedgames.util.io_manager.io.IOSyncable;
import com.gildedgames.util.player.common.IPlayerHookPool;
import com.gildedgames.util.player.common.player.IPlayerHook;
import com.gildedgames.util.player.common.player.PlayerProfile;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

public class PlayerServices {
    private List<IPlayerHookPool<?>> playerHookPools;

    public List<IPlayerHookPool<?>> getPools() {
        if (this.playerHookPools == null) {
            this.playerHookPools = new ArrayList();
        }
        return this.playerHookPools;
    }

    public String getPoolID(IPlayerHookPool<?> playerHookPool) {
        return playerHookPool.getName();
    }

    public IPlayerHookPool<?> getPool(String id) {
        for (IPlayerHookPool<?> pool : this.getPools()) {
            if (!pool.getName().equals(id)) continue;
            return pool;
        }
        return null;
    }

    public void writeHookReference(IPlayerHook playerHook, ByteBuf buf) {
        String poolID = this.getPoolID(playerHook.getParentPool());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)poolID);
        playerHook.getProfile().syncTo(buf, IOSyncable.SyncSide.CLIENT);
    }

    public IPlayerHook readHookReference(EntityPlayer player, ByteBuf buf) {
        IPlayerHookPool<?> manager = this.getPool(ByteBufUtils.readUTF8String((ByteBuf)buf));
        PlayerProfile profile = new PlayerProfile();
        profile.syncFrom(buf, IOSyncable.SyncSide.SERVER);
        Object playerHook = manager.get(player);
        return playerHook;
    }

    public IPlayerHook readHookReference(Side side, ByteBuf buf) {
        IPlayerHookPool<?> manager = this.getPool(ByteBufUtils.readUTF8String((ByteBuf)buf));
        PlayerProfile profile = new PlayerProfile();
        profile.syncFrom(buf, IOSyncable.SyncSide.SERVER);
        Object playerHook = manager.get(profile.getUUID());
        return playerHook;
    }

    public void registerPlayerHookPool(IPlayerHookPool<?> playerPool) {
        this.getPools().add(playerPool);
    }
}

