/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.player.common;

import com.gildedgames.util.core.UtilCore;
import com.gildedgames.util.player.PlayerCore;
import com.gildedgames.util.player.common.IPlayerHookPool;
import com.gildedgames.util.player.common.networking.messages.MessagePlayerHook;
import com.gildedgames.util.player.common.networking.messages.MessagePlayerHookClient;
import com.gildedgames.util.player.common.player.IPlayerHook;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;

public class PlayerEventHandler {
    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            for (IPlayerHookPool<?> manager : PlayerCore.locate().getPools()) {
                manager.get(player).getProfile().entityInit(player);
                manager.get(player).entityInit(player);
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.entity instanceof EntityPlayer) {
            for (IPlayerHookPool<?> manager : PlayerCore.locate().getPools()) {
                if (manager.get((EntityPlayer)event.entity).onLivingAttack(event.source)) continue;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            for (IPlayerHookPool<?> manager : PlayerCore.locate().getPools()) {
                Object playerHook = manager.get(player);
                if (playerHook.getProfile().getEntity() == null) {
                    playerHook.getProfile().setEntity(player);
                }
                playerHook.onUpdate();
                if (event.entity.field_70170_p.field_72995_K) {
                    this.refreshServer((IPlayerHook)playerHook);
                    continue;
                }
                this.refreshClients((IPlayerHook)playerHook);
            }
        }
    }

    public void refreshServer(IPlayerHook playerHook) {
        if (playerHook.isDirty()) {
            UtilCore.NETWORK.sendToServer(new MessagePlayerHookClient(playerHook));
            playerHook.markClean();
        }
    }

    public void refreshClients(IPlayerHook playerHook) {
        if (playerHook.isDirty()) {
            UtilCore.NETWORK.sendToAll(new MessagePlayerHook(playerHook));
            playerHook.markClean();
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.entity instanceof EntityPlayer) {
            for (IPlayerHookPool<?> manager : PlayerCore.locate().getPools()) {
                EntityPlayer player = (EntityPlayer)event.entity;
                manager.get(player).onDeath();
            }
        }
    }

    @SubscribeEvent
    public void onLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        for (IPlayerHookPool<?> manager : PlayerCore.locate().getPools()) {
            Object playerHook = manager.get(event.player);
            playerHook.getProfile().setLoggedIn(true);
            UtilCore.NETWORK.sendToAll(new MessagePlayerHook((IPlayerHook)playerHook));
        }
    }

    @SubscribeEvent
    public void onLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        for (IPlayerHookPool<?> manager : PlayerCore.locate().getPools()) {
            Object playerHook = manager.get(event.player);
            playerHook.getProfile().setEntity(null);
            playerHook.getProfile().setLoggedIn(false);
            UtilCore.NETWORK.sendToAll(new MessagePlayerHook((IPlayerHook)playerHook));
        }
    }

    @SubscribeEvent
    public void onChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        for (IPlayerHookPool<?> manager : PlayerCore.locate().getPools()) {
            Object playerHook = manager.get(event.player);
            playerHook.onChangedDimension();
        }
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        for (IPlayerHookPool<?> manager : PlayerCore.locate().getPools()) {
            Object playerHook = manager.get(event.player);
            playerHook.onRespawn();
        }
    }
}

