/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.player.common.networking.messages;

import com.gildedgames.util.io_manager.io.IOSyncable;
import com.gildedgames.util.player.PlayerCore;
import com.gildedgames.util.player.common.IPlayerHookPool;
import com.gildedgames.util.player.common.player.IPlayerHook;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.UUID;

public class MessagePlayerHook
implements IMessage {
    public IPlayerHook playerHook;
    public int managerID;
    public ByteBuf buf;

    public MessagePlayerHook() {
    }

    public MessagePlayerHook(IPlayerHook playerHook) {
        this.playerHook = playerHook;
    }

    public void fromBytes(ByteBuf buf) {
        this.buf = buf;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerHook.getParentPool().getName());
        UUID uuid = this.playerHook.getProfile().getUUID();
        buf.writeLong(uuid.getMostSignificantBits());
        buf.writeLong(uuid.getLeastSignificantBits());
        this.playerHook.getProfile().syncTo(buf, IOSyncable.SyncSide.CLIENT);
        this.playerHook.syncTo(buf, IOSyncable.SyncSide.CLIENT);
    }

    public static class Handler
    implements IMessageHandler<MessagePlayerHook, IMessage> {
        public IMessage onMessage(MessagePlayerHook message, MessageContext ctx) {
            if (ctx.side.isClient()) {
                IPlayerHookPool<?> manager = PlayerCore.locate().getPool(ByteBufUtils.readUTF8String((ByteBuf)message.buf));
                Object playerHook = manager.get(new UUID(message.buf.readLong(), message.buf.readLong()));
                playerHook.getProfile().syncFrom(message.buf, IOSyncable.SyncSide.SERVER);
                playerHook.syncFrom((ByteBuf)message.buf, IOSyncable.SyncSide.SERVER);
            }
            return null;
        }
    }
}

