/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.player.server;

import com.gildedgames.util.core.UtilCore;
import com.gildedgames.util.player.PlayerCore;
import com.gildedgames.util.player.common.IPlayerHookPool;
import com.gildedgames.util.player.common.player.IPlayerHook;
import com.gildedgames.util.player.common.player.PlayerProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class PlayerHookSaveHandler {
    public File playerDirectory;

    @SubscribeEvent
    public void onSavePlayerFile(PlayerEvent.SaveToFile event) {
        this.playerDirectory = new File(UtilCore.getWorldDirectory(), "playerdata/");
        this.writePlayerData(UUID.fromString(event.playerUUID), PlayerCore.locate().getPools());
    }

    @SubscribeEvent
    public void onLoadPlayerFile(PlayerEvent.LoadFromFile event) {
        this.playerDirectory = new File(UtilCore.getWorldDirectory(), "playerdata/");
        this.readPlayerData(UUID.fromString(event.playerUUID), event.entityPlayer, PlayerCore.locate().getPools());
    }

    public void writePlayerData(UUID uuid, List<IPlayerHookPool<?>> pools) {
        for (IPlayerHookPool<?> manager : pools) {
            if (!manager.shouldSave()) continue;
            Object playerHook = manager.get(uuid);
            NBTTagCompound tag = new NBTTagCompound();
            playerHook.getProfile().write(tag);
            playerHook.write((NBTTagCompound)tag);
            File prefix = new File(this.playerDirectory, manager.getName());
            prefix.mkdirs();
            File tempPlayerFile = new File(prefix, uuid + ".dat.tmp");
            File playerFile = new File(prefix, uuid + ".dat");
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)new FileOutputStream(tempPlayerFile));
                if (playerFile.exists()) {
                    playerFile.delete();
                }
                tempPlayerFile.renameTo(playerFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private <T extends IPlayerHook> NBTTagCompound readPlayerHook(File playerFile, IPlayerHookPool<T> pool, EntityPlayer entityplayer) {
        try {
            FileInputStream inputStream = new FileInputStream(playerFile);
            NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)inputStream);
            PlayerProfile profile = new PlayerProfile();
            profile.read(tag);
            profile.setEntity(entityplayer);
            T playerHook = pool.getFactory().create(profile, pool);
            playerHook.read((NBTTagCompound)tag);
            pool.add(playerHook);
            return tag;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void readPlayerData(UUID uuid, EntityPlayer entityplayer, List<IPlayerHookPool<?>> pools) {
        for (IPlayerHookPool<?> manager : pools) {
            File prefix = new File(this.playerDirectory, manager.getName());
            prefix.mkdirs();
            File playerFile = new File(prefix, uuid + ".dat");
            if (!playerFile.exists() || !playerFile.isFile()) continue;
            this.readPlayerHook(playerFile, manager, entityplayer);
        }
    }

    public void flushData() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        ServerConfigurationManager configManager = server.func_71203_ab();
        for (int i = 0; i < configManager.field_72404_b.size(); ++i) {
            EntityPlayerMP player = (EntityPlayerMP)configManager.field_72404_b.get(i);
            this.writePlayerData(player.func_110124_au(), PlayerCore.locate().getPools());
        }
    }
}

