/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.spawning;

import com.gildedgames.util.spawning.SpawnCondition;
import com.gildedgames.util.spawning.SpawnEntry;
import com.gildedgames.util.spawning.SpawnManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class ScheduledSpawn {
    private final SpawnEntry entry;
    private final int posX;
    private final int posZ;
    private int spawnAttempts;
    private final SpawnManager spawnManager;

    public ScheduledSpawn(SpawnManager spawnManager, SpawnEntry entry, int posX, int posZ) {
        this.entry = entry;
        this.posX = posX;
        this.posZ = posZ;
        this.spawnManager = spawnManager;
    }

    public int getSpawnAttempts() {
        return this.spawnAttempts;
    }

    public boolean spawn(int areaSize, World world) {
        int spawnY = this.entry.onGround() ? this.spawnManager.getTopSolidOrLiquidBlock(world, this.posX, this.posZ) : this.entry.getHeight(world.field_73012_v);
        if (spawnY > this.entry.getMinimumHeight() && spawnY < this.entry.getMaximumHeight() && this.entry.shouldAttempt(world, this.posX, spawnY, this.posZ)) {
            try {
                Constructor<? extends Entity> cons = this.entry.getEntityClass().getConstructor(World.class);
                Entity entity = cons.newInstance(world);
                entity.func_70012_b((double)this.posX, (double)spawnY, (double)this.posZ, 0.0f, 0.0f);
                for (SpawnCondition condition : this.spawnManager.getSpawnConditions()) {
                    if (condition.canSpawn(areaSize, this, entity)) continue;
                    this.spawnAttempts = this.spawnManager.getMaxSpawnAttempts();
                    return false;
                }
                if (!(entity instanceof EntityLiving) || ((EntityLiving)entity).func_70601_bi()) {
                    int playerRange = this.spawnManager.getSpawnDistanceFromPlayer();
                    List listOfPlayers = world.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.posX - playerRange), (double)0.0, (double)(this.posZ - playerRange), (double)(this.posX + playerRange), (double)world.func_72940_L(), (double)(this.posZ + playerRange)));
                    for (EntityPlayer player : listOfPlayers) {
                        if (!(entity.func_70032_d((Entity)player) < (float)playerRange)) continue;
                        ++this.spawnAttempts;
                        return false;
                    }
                    world.func_72838_d(entity);
                    if (entity instanceof EntityLiving) {
                        EntityLiving living = (EntityLiving)entity;
                        living.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", living.func_70681_au().nextGaussian() * 0.05, 1));
                    }
                    return true;
                }
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        ++this.spawnAttempts;
        return false;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosZ() {
        return this.posZ;
    }
}

