/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.spawning;

import com.gildedgames.util.spawning.ScheduledSpawn;
import com.gildedgames.util.spawning.SpawnEntry;
import com.gildedgames.util.spawning.SpawnManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;

public class SpawnArea {
    protected final int areaX;
    protected final int areaZ;
    protected final List<SpawnEntry> spawnEntries;
    protected final List<ScheduledSpawn> scheduledSpawns = new ArrayList<ScheduledSpawn>();
    protected final SpawnManager spawnManager;

    public SpawnArea(SpawnManager spawnManager, int areaX, int areaZ, List<SpawnEntry> spawnEntries) {
        this.areaX = areaX;
        this.areaZ = areaZ;
        this.spawnEntries = spawnEntries;
        this.spawnManager = spawnManager;
    }

    public void schedule(World world, int chunksPerArea, int groupScattering, Random rand) {
        for (SpawnEntry entry : this.spawnEntries) {
            int numGroups = entry.getGroupsInArea(rand);
            for (int groupsC = 0; groupsC < numGroups; ++groupsC) {
                int groupSize = entry.getGroupSize(rand);
                int blocksPerArea = chunksPerArea << 4;
                int groupSpawnX = this.areaX * blocksPerArea + rand.nextInt(blocksPerArea);
                int groupSpawnZ = this.areaZ * blocksPerArea + rand.nextInt(blocksPerArea);
                for (int j = 0; j < groupSize; ++j) {
                    int scatterX = -groupScattering + rand.nextInt(groupScattering * 2);
                    int scatterZ = -groupScattering + rand.nextInt(groupScattering * 2);
                    int posX = groupSpawnX + scatterX;
                    int posZ = groupSpawnZ + scatterZ;
                    this.scheduledSpawns.add(new ScheduledSpawn(this.spawnManager, entry, posX, posZ));
                }
            }
        }
    }

    public void performChunkSpawning(World world, int chunksPerArea, int chunkX, int chunkZ) {
        Iterator<ScheduledSpawn> iter = this.scheduledSpawns.iterator();
        while (iter.hasNext()) {
            ScheduledSpawn scheduledSpawn = iter.next();
            int spawnChunkX = scheduledSpawn.getPosX() >> 4;
            int spawnChunkZ = scheduledSpawn.getPosZ() >> 4;
            if (chunkX != spawnChunkX || chunkZ != spawnChunkZ || !scheduledSpawn.spawn(chunksPerArea, world)) continue;
            iter.remove();
        }
    }

    public int getAreaX() {
        return this.areaX;
    }

    public int getAreaZ() {
        return this.areaZ;
    }
}

