/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.spawning;

import com.gildedgames.util.spawning.ScheduledSpawn;
import com.gildedgames.util.spawning.SpawnArea;
import com.gildedgames.util.spawning.SpawnEntry;
import com.gildedgames.util.spawning.SpawnManager;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class SpawnAreaPerTick
extends SpawnArea {
    private boolean isAwake = true;
    private boolean shouldRespawn = false;
    private int secondsUpdated = 0;

    public SpawnAreaPerTick(SpawnManager spawnManager, int areaX, int areaZ, List<SpawnEntry> spawnEntries) {
        super(spawnManager, areaX, areaZ, spawnEntries);
    }

    public boolean isAwake() {
        return this.isAwake;
    }

    public int getAmountOfUpdates() {
        return this.secondsUpdated;
    }

    public void wake() {
        this.isAwake = true;
    }

    public boolean shouldRespawn() {
        return this.shouldRespawn;
    }

    public void setShouldRespawn(boolean shouldRespawn) {
        this.shouldRespawn = shouldRespawn;
    }

    public void onUpdate(int areaSize, World world) {
        ++this.secondsUpdated;
        Iterator iter = this.scheduledSpawns.iterator();
        while (iter.hasNext()) {
            ScheduledSpawn scheduledSpawn = (ScheduledSpawn)iter.next();
            if (!scheduledSpawn.spawn(areaSize, world) && scheduledSpawn.getSpawnAttempts() < this.spawnManager.getMaxSpawnAttempts()) continue;
            iter.remove();
        }
        this.isAwake = false;
    }

    public boolean noSchedulesLeft() {
        return this.scheduledSpawns.isEmpty();
    }

    @Override
    public void schedule(World world, int areaSize, int groupScattering, Random rand) {
        int targetEntities;
        IEntitySelector entitySelector;
        int posX = this.areaX * areaSize * 16;
        int posZ = this.areaZ * areaSize * 16;
        int spawningRange = areaSize * 16;
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)posX, (double)0.0, (double)posZ, (double)(posX + spawningRange), (double)world.func_72940_L(), (double)(posZ + spawningRange));
        List listOfEntitiesInArea = world.func_82733_a(Entity.class, bb, entitySelector = new IEntitySelector(){

            public boolean func_82704_a(Entity entity) {
                for (SpawnEntry s : SpawnAreaPerTick.this.spawnEntries) {
                    if (s.getEntityClass() != entity.getClass()) continue;
                    return true;
                }
                return false;
            }
        });
        int entitiesInArea = listOfEntitiesInArea.size();
        if (entitiesInArea > (targetEntities = this.spawnManager.getTargetAmountOfEntities(world, rand))) {
            return;
        }
        for (SpawnEntry entry : this.spawnEntries) {
            int entityCount = 0;
            for (Entity entity : listOfEntitiesInArea) {
                if (entry.getEntityClass() != entity.getClass()) continue;
                ++entityCount;
            }
            if (!entry.shouldSpawnMore(entityCount, rand)) continue;
            int numGroups = entry.getGroupsInArea(rand);
            for (int i = 0; i < numGroups; ++i) {
                int amountOfSpawns = this.scheduledSpawns.size();
                if (entitiesInArea + amountOfSpawns > targetEntities) {
                    return;
                }
                int groupSize = entry.getGroupSize(rand);
                int groupX = posX + rand.nextInt(spawningRange);
                int groupZ = posZ + rand.nextInt(spawningRange);
                for (int j = 0; j < groupSize; ++j) {
                    int scatterX = -groupScattering + rand.nextInt(groupScattering * 2);
                    int scatterZ = -groupScattering + rand.nextInt(groupScattering * 2);
                    ScheduledSpawn scheduledSpawn = new ScheduledSpawn(this.spawnManager, entry, groupX + scatterX, groupZ + scatterZ);
                    this.scheduledSpawns.add(scheduledSpawn);
                }
            }
        }
    }
}

