/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.spawning;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class SpawnEntry {
    private final Class<? extends Entity> entityClass;
    private final float avgGroupsInArea;
    private final float groupsInAreaDeviation;
    private final float avgEntitiesInArea;
    private final float entitiesInAreaDeviation;
    private final int minGroupSize;
    private final int maxGroupSize;
    private final boolean onGround;

    public SpawnEntry(Class<? extends Entity> entityClass, int minGroupSize, int maxGroupSize, float avgGroupsInArea) {
        this(entityClass, minGroupSize, maxGroupSize, avgGroupsInArea, true);
    }

    public SpawnEntry(Class<? extends Entity> entityClass, int minGroupSize, int maxGroupSize, float avgGroupsInArea, boolean onGround) {
        this(entityClass, minGroupSize, maxGroupSize, avgGroupsInArea, avgGroupsInArea / 2.0f, onGround);
    }

    public SpawnEntry(Class<? extends Entity> entityClass, int minGroupSize, int maxGroupSize, float avgGroupsInArea, float groupsInAreaDeviation, boolean onGround) {
        this.entityClass = entityClass;
        this.minGroupSize = minGroupSize;
        this.maxGroupSize = maxGroupSize;
        this.onGround = onGround;
        this.avgGroupsInArea = avgGroupsInArea;
        this.groupsInAreaDeviation = groupsInAreaDeviation;
        this.avgEntitiesInArea = avgGroupsInArea * (float)(maxGroupSize - minGroupSize);
        this.entitiesInAreaDeviation = groupsInAreaDeviation / avgGroupsInArea * this.avgEntitiesInArea;
    }

    public Class<? extends Entity> getEntityClass() {
        return this.entityClass;
    }

    public int getGroupsInArea(Random rand) {
        return this.gaussianAbove0(rand, this.avgGroupsInArea, this.groupsInAreaDeviation);
    }

    public int getGroupSize(Random rand) {
        return this.getRandomNumberBetween(rand, this.minGroupSize, this.maxGroupSize);
    }

    public boolean onGround() {
        return this.onGround;
    }

    public int getMinimumHeight() {
        return 20;
    }

    public int getMaximumHeight() {
        return 256;
    }

    public int getHeight(Random rand) {
        return this.getRandomNumberBetween(rand, this.getMinimumHeight(), this.getMaximumHeight());
    }

    protected int getRandomNumberBetween(Random rand, int min, int max) {
        return min + rand.nextInt(max - min + 1);
    }

    public boolean shouldAttempt(World world, int posX, int posY, int posZ) {
        return true;
    }

    private int gaussianAbove0(Random rand, float avg, float deviation) {
        return (int)Math.round(Math.max(0.0, rand.nextGaussian() * (double)deviation + (double)avg));
    }

    public boolean shouldSpawnMore(int currentAmountInArea, Random rand) {
        int randAmountOfEntities = this.gaussianAbove0(rand, this.avgEntitiesInArea, this.entitiesInAreaDeviation);
        return randAmountOfEntities > currentAmountInArea;
    }
}

