/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.spawning;

import com.gildedgames.util.core.ICore;
import com.gildedgames.util.player.PlayerCore;
import com.gildedgames.util.player.common.IPlayerHookPool;
import com.gildedgames.util.player.common.PlayerHookPool;
import com.gildedgames.util.spawning.SpawnManager;
import com.gildedgames.util.spawning.SpawnSettings;
import com.gildedgames.util.spawning.player.PlayerSpawning;
import com.gildedgames.util.spawning.player.PlayerSpawningFactory;
import com.gildedgames.util.spawning.util.DefaultSpawnSettings;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class SpawningCore
implements ICore {
    private static List<SpawnManager> spawnManagers = new ArrayList<SpawnManager>();
    private IPlayerHookPool<PlayerSpawning> players = new PlayerHookPool<PlayerSpawning>("spawning", new PlayerSpawningFactory(), Side.SERVER);
    private IPlayerHookPool<PlayerSpawning> stub = new PlayerHookPool<PlayerSpawning>("spawning", new PlayerSpawningFactory(), Side.CLIENT);

    public static SpawnManager createAndRegisterSpawnManager(int dimensionId) {
        return SpawningCore.createAndRegisterSpawnManager(dimensionId, new DefaultSpawnSettings());
    }

    public static SpawnManager createAndRegisterSpawnManager(int dimensionId, SpawnSettings settings) {
        SpawnManager s = new SpawnManager(dimensionId, settings);
        spawnManagers.add(s);
        return s;
    }

    public static List<SpawnManager> getSpawnManagersFor(int dimensionId) {
        ArrayList<SpawnManager> selected = new ArrayList<SpawnManager>();
        for (SpawnManager spawnManager : spawnManagers) {
            if (spawnManager.getDimensionId() != dimensionId) continue;
            selected.add(spawnManager);
        }
        return selected;
    }

    public static void registerBlacklistedBlock(Block block) {
        SpawnManager.registerBlacklistedBlock(block);
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            World world = event.world;
            if (!world.field_72995_K) {
                List<SpawnManager> spawnManagers = SpawningCore.getSpawnManagersFor(world.field_73011_w.field_76574_g);
                for (SpawnManager spawnManager : spawnManagers) {
                    spawnManager.tickSpawning(world, this.players.getPlayerHooks());
                }
            }
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        PlayerCore.INSTANCE.registerPlayerPool(this.stub, this.players);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Override
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
    }

    @Override
    public void serverStopping(FMLServerStoppingEvent event) {
        for (SpawnManager spawnManager : spawnManagers) {
            spawnManager.clear();
        }
    }

    @Override
    public void serverStopped(FMLServerStoppedEvent event) {
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
    }

    @Override
    public void serverStarted(FMLServerStartedEvent event) {
    }

    @Override
    public void flushData() {
    }
}

