/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.tab.client;

import com.gildedgames.util.core.UtilCore;
import com.gildedgames.util.tab.client.util.RenderTabGroup;
import com.gildedgames.util.tab.common.TabAPI;
import com.gildedgames.util.tab.common.networking.packet.PacketOpenTab;
import com.gildedgames.util.tab.common.util.ITab;
import com.gildedgames.util.tab.common.util.ITabGroup;
import com.gildedgames.util.tab.common.util.ITabGroupHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.GuiOpenEvent;
import org.lwjgl.input.Mouse;

public class TabClientEvents {
    @SideOnly(value=Side.CLIENT)
    private static final RenderTabGroup tabGroupRenderer = new RenderTabGroup();

    @SideOnly(value=Side.CLIENT)
    private boolean isTabValid(ITab tab, GuiScreen gui) {
        return tab.getGuiClasses().contains(gui.getClass());
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        ITabGroup activeGroup;
        GuiScreen gui = event.gui;
        ITabGroupHandler groupHandler = TabAPI.INSTANCE.getActiveGroup();
        if (groupHandler != null && (activeGroup = groupHandler.getSide(Side.CLIENT)) != null) {
            ITab selectedTab = activeGroup.getSelectedTab();
            if (event.gui != null && this.isTabValid(selectedTab, gui)) {
                return;
            }
            TabAPI.INSTANCE.setActiveGroup(null);
        }
        for (ITabGroupHandler tabGroupHandler : TabAPI.INSTANCE.getRegisteredTabGroups().values()) {
            ITabGroup tabGroup = tabGroupHandler.getSide(Side.CLIENT);
            for (ITab tab : tabGroup.getTabs()) {
                if (tab == null || event.gui == null || !this.isTabValid(tab, gui)) continue;
                ITab selectedTab = tabGroup.getSelectedTab();
                if (selectedTab != null && !this.isTabValid(selectedTab, gui)) {
                    if (tabGroup.getRememberSelectedTab()) {
                        event.setCanceled(true);
                        if (tabGroup.getRememberedTab() != null) {
                            tabGroup.setSelectedTab(tabGroup.getRememberedTab());
                        } else {
                            tabGroup.setSelectedTab(tabGroup.getEnabledTabs().get(0));
                        }
                        tabGroup.getSelectedTab().onOpen((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                        UtilCore.NETWORK.sendToServer(new PacketOpenTab(tabGroup.getSelectedTab()));
                    } else {
                        tabGroup.setSelectedTab(tabGroup.getEnabledTabs().get(0));
                    }
                } else {
                    tabGroup.setSelectedTab(tab);
                }
                TabAPI.INSTANCE.setActiveGroup(tabGroupHandler);
                return;
            }
        }
    }

    @SubscribeEvent
    public void tickStart(TickEvent.ClientTickEvent event) {
        ITabGroup activeGroup;
        ITabGroupHandler groupHandler;
        if (event.phase == TickEvent.Phase.START && (groupHandler = TabAPI.INSTANCE.getActiveGroup()) != null && (activeGroup = groupHandler.getSide(Side.CLIENT)) != null) {
            while (Mouse.next()) {
                ITab hoveredTab = null;
                if (activeGroup != null) {
                    hoveredTab = tabGroupRenderer.getHoveredTab(activeGroup);
                }
                if (Mouse.getEventButtonState() && hoveredTab != null) {
                    if (hoveredTab == activeGroup.getSelectedTab()) continue;
                    activeGroup.getSelectedTab().onClose((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                    activeGroup.setSelectedTab(hoveredTab);
                    if (hoveredTab != activeGroup.getRememberedTab() && hoveredTab.isRemembered()) {
                        if (activeGroup.getRememberedTab() != null) {
                            activeGroup.getRememberedTab().onClose((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                        }
                        activeGroup.setRememberedTab(hoveredTab);
                    }
                    hoveredTab.onOpen((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                    UtilCore.NETWORK.sendToServer(new PacketOpenTab(hoveredTab));
                    continue;
                }
                if (Minecraft.func_71410_x().field_71462_r == null) continue;
                Minecraft.func_71410_x().field_71462_r.func_146274_d();
            }
        }
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.RenderTickEvent event) {
        ITabGroup activeGroup;
        ITabGroupHandler groupHandler;
        if (event.phase == TickEvent.Phase.END && (groupHandler = TabAPI.INSTANCE.getActiveGroup()) != null && (activeGroup = groupHandler.getSide(Side.CLIENT)) != null) {
            tabGroupRenderer.render(activeGroup);
        }
    }
}

