/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.ui.data.rect;

import com.gildedgames.util.core.ObjectFilter;
import com.gildedgames.util.ui.data.Pos2D;
import com.gildedgames.util.ui.data.rect.BuildIntoRectHolder;
import com.gildedgames.util.ui.data.rect.Dim2D;
import com.gildedgames.util.ui.data.rect.Rect;
import com.gildedgames.util.ui.data.rect.RectBuilder;
import com.gildedgames.util.ui.data.rect.RectHolder;
import com.gildedgames.util.ui.data.rect.RectListener;
import com.gildedgames.util.ui.data.rect.RectModifier;
import com.gildedgames.util.ui.input.InputProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ModDim2D
implements Rect {
    private List<RectModifier> modifiers = new ArrayList<RectModifier>();
    private List<RectListener> listeners = new ArrayList<RectListener>();
    private Rect originalState = Dim2D.flush();
    private Rect modifiedState = Dim2D.flush();
    private BuildIntoRectHolder buildInto = new BuildIntoRectHolder(this);
    private RectListener ourListener = this.createListener();
    private boolean preventRecursion = false;

    public static ModDim2D build() {
        return new ModDim2D();
    }

    public static ModDim2D build(Rect rect) {
        ModDim2D dim = new ModDim2D();
        dim.set(rect);
        return dim;
    }

    public static ModDim2D clone(RectHolder owner) {
        return owner.dim().clone();
    }

    private RectListener createListener() {
        return new RectListener(){

            @Override
            public void notifyDimChange(List<RectModifier.ModifierType> types) {
                ModDim2D.this.refreshModifiedState();
            }
        };
    }

    public Rect originalState() {
        return this.originalState;
    }

    private Rect modifiedState() {
        for (RectModifier modifier : this.modifiers) {
            modifier.modifyingWith().updateState();
        }
        return this.modifiedState;
    }

    public BuildIntoRectHolder mod() {
        return this.buildInto;
    }

    public RectBuilder copyRect() {
        return new RectBuilder(this);
    }

    public ModDim2D clone() {
        ModDim2D clone = new ModDim2D();
        clone.set(this);
        return clone;
    }

    public ModDim2D set(RectHolder holder) {
        this.set(holder.dim());
        return this;
    }

    public ModDim2D set(Rect dim) {
        this.originalState = dim;
        this.refreshModifiedState();
        this.buildInto.set(this.originalState);
        return this;
    }

    public ModDim2D set(ModDim2D modDim) {
        this.modifiers = new ArrayList<RectModifier>(modDim.modifiers);
        this.listeners = new ArrayList<RectListener>(modDim.listeners);
        this.originalState = modDim.originalState;
        this.modifiedState = modDim.modifiedState;
        this.buildInto.set(this.originalState);
        return this;
    }

    protected void refreshModifiedState() {
        Rect oldModifiedState = this.modifiedState;
        float degrees = this.originalState.degrees();
        float scale = this.originalState.scale();
        float posX = this.originalState.x();
        float posY = this.originalState.y();
        float width = this.originalState.width();
        float height = this.originalState.height();
        for (RectModifier modifier : this.mods()) {
            RectHolder modifyingWith;
            if (modifier == null || (modifyingWith = modifier.modifyingWith()).dim() == null || modifyingWith.dim() == this) continue;
            if (modifier.getType().equals((Object)RectModifier.ModifierType.ROTATION)) {
                degrees += modifyingWith.dim().degrees();
            }
            if (modifier.getType().equals((Object)RectModifier.ModifierType.SCALE)) {
                scale *= modifyingWith.dim().scale();
            }
            if (modifier.getType().equals((Object)RectModifier.ModifierType.X)) {
                posX += modifyingWith.dim().x();
            }
            if (modifier.getType().equals((Object)RectModifier.ModifierType.Y)) {
                posY += modifyingWith.dim().y();
            }
            if (modifier.getType().equals((Object)RectModifier.ModifierType.WIDTH)) {
                width += modifyingWith.dim().width();
            }
            if (!modifier.getType().equals((Object)RectModifier.ModifierType.HEIGHT)) continue;
            height += modifyingWith.dim().height();
        }
        float offsetX = this.originalState.isCenteredX() ? width * this.originalState.scale() / 2.0f : 0.0f;
        float offsetY = this.originalState.isCenteredY() ? height * this.originalState.scale() / 2.0f : 0.0f;
        this.modifiedState = Dim2D.build(this.originalState).pos(posX -= offsetX, posY -= offsetY).area(width *= this.originalState.scale(), height *= this.originalState.scale()).degrees(degrees).scale(scale).flush();
        if (this.preventRecursion) {
            return;
        }
        this.preventRecursion = true;
        List<RectModifier.ModifierType> changedTypes = ModDim2D.getChangedTypes(oldModifiedState, this.modifiedState);
        for (RectListener listener : this.listeners) {
            listener.notifyDimChange(changedTypes);
        }
        this.preventRecursion = false;
    }

    public static List<RectModifier.ModifierType> getChangedTypes(Rect r1, Rect r2) {
        ArrayList<RectModifier.ModifierType> types = new ArrayList<RectModifier.ModifierType>();
        if (r1.x() != r2.x()) {
            types.add(RectModifier.ModifierType.X);
        }
        if (r1.y() != r2.y()) {
            types.add(RectModifier.ModifierType.Y);
        }
        if (r1.width() != r2.width()) {
            types.add(RectModifier.ModifierType.WIDTH);
        }
        if (r1.height() != r2.height()) {
            types.add(RectModifier.ModifierType.HEIGHT);
        }
        if (r1.degrees() != r2.degrees()) {
            types.add(RectModifier.ModifierType.ROTATION);
        }
        return types;
    }

    public Collection<RectModifier> mods() {
        return this.modifiers;
    }

    public boolean containsModifier(RectHolder modifier) {
        return this.modifiers.contains(modifier);
    }

    public ModDim2D clear(RectModifier.ModifierType ... types) {
        if (types.length == 0) {
            for (RectModifier modifier : this.modifiers) {
                modifier.modifyingWith().dim().removeListener(this.ourListener);
            }
            this.modifiers.clear();
            this.refreshModifiedState();
            return this;
        }
        ArrayList<RectModifier.ModifierType> list = new ArrayList<RectModifier.ModifierType>();
        for (RectModifier.ModifierType type : types) {
            list.add(type);
        }
        final List<RectModifier.ModifierType> filteredTypes = this.filterModifierTypes(list);
        this.modifiers = ObjectFilter.getTypesFrom(this.modifiers, new ObjectFilter.FilterCondition<RectModifier>(this.modifiers){

            @Override
            public boolean isType(RectModifier modifier) {
                for (RectModifier.ModifierType type : ObjectFilter.getTypesFrom(filteredTypes, RectModifier.ModifierType.class)) {
                    if (!modifier.getType().equals((Object)type)) continue;
                    return false;
                }
                return true;
            }
        });
        this.refreshModifiedState();
        return this;
    }

    private List<RectModifier.ModifierType> filterModifierTypes(List<RectModifier.ModifierType> types) {
        if (types.contains((Object)RectModifier.ModifierType.AREA)) {
            types.remove((Object)RectModifier.ModifierType.AREA);
            if (!types.contains((Object)RectModifier.ModifierType.WIDTH)) {
                types.add(RectModifier.ModifierType.WIDTH);
            }
            if (!types.contains((Object)RectModifier.ModifierType.HEIGHT)) {
                types.add(RectModifier.ModifierType.HEIGHT);
            }
        }
        if (types.contains((Object)RectModifier.ModifierType.POS)) {
            types.remove((Object)RectModifier.ModifierType.POS);
            if (!types.contains((Object)RectModifier.ModifierType.X)) {
                types.add(RectModifier.ModifierType.X);
            }
            if (!types.contains((Object)RectModifier.ModifierType.Y)) {
                types.add(RectModifier.ModifierType.Y);
            }
        }
        if (types.contains((Object)RectModifier.ModifierType.ALL)) {
            types.remove((Object)RectModifier.ModifierType.ALL);
            for (RectModifier.ModifierType type : RectModifier.ModifierType.values()) {
                if (types.contains((Object)type)) continue;
                types.add(type);
            }
        }
        return types;
    }

    public ModDim2D add(RectHolder modifyingWith, RectModifier.ModifierType mandatoryType, RectModifier.ModifierType ... otherTypes) {
        if (modifyingWith.dim().equals(this)) {
            throw new IllegalArgumentException();
        }
        for (RectModifier.ModifierType type : this.filterModifierTypes(this.toList(mandatoryType, otherTypes))) {
            RectModifier modifier = new RectModifier(modifyingWith, type);
            if (this.modifiers.contains(modifier)) continue;
            this.modifiers.add(modifier);
            modifyingWith.dim().addListener(this.ourListener);
            this.refreshModifiedState();
        }
        return this;
    }

    private List<RectModifier.ModifierType> toList(RectModifier.ModifierType manda, RectModifier.ModifierType ... types) {
        ArrayList<RectModifier.ModifierType> list = new ArrayList<RectModifier.ModifierType>();
        list.add(manda);
        for (RectModifier.ModifierType type : types) {
            list.add(type);
        }
        return list;
    }

    public boolean remove(RectHolder modifyingWith, RectModifier.ModifierType mandatoryType, RectModifier.ModifierType ... otherTypes) {
        boolean success = true;
        block0: for (RectModifier.ModifierType type : this.filterModifierTypes(this.toList(mandatoryType, otherTypes))) {
            Iterator<RectModifier> iter = this.modifiers.iterator();
            while (iter.hasNext()) {
                RectModifier modifier = iter.next();
                if (modifier.modifyingWith() != modifyingWith || !modifier.getType().equals((Object)type)) continue;
                iter.remove();
                continue block0;
            }
            success = false;
        }
        if (!this.hasModifiersFor(modifyingWith)) {
            modifyingWith.dim().removeListener(this.ourListener);
        }
        this.refreshModifiedState();
        return success;
    }

    private boolean hasModifiersFor(RectHolder holder) {
        for (RectModifier rModifier : this.modifiers) {
            if (!rModifier.modifyingWith().equals(holder)) continue;
            return true;
        }
        return false;
    }

    public void addListener(RectListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean removeListener(RectListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public float degrees() {
        return this.modifiedState().degrees();
    }

    @Override
    public float originX() {
        return this.modifiedState().originX();
    }

    @Override
    public float originY() {
        return this.modifiedState().originY();
    }

    @Override
    public float scale() {
        return this.modifiedState().scale();
    }

    @Override
    public float maxX() {
        return this.modifiedState().maxX();
    }

    @Override
    public float maxY() {
        return this.modifiedState().maxY();
    }

    @Override
    public float x() {
        return this.modifiedState().x();
    }

    @Override
    public float y() {
        return this.modifiedState().y();
    }

    @Override
    public float width() {
        return this.modifiedState().width();
    }

    @Override
    public float height() {
        return this.modifiedState().height();
    }

    @Override
    public boolean isCenteredX() {
        return this.modifiedState().isCenteredX();
    }

    @Override
    public boolean isCenteredY() {
        return this.modifiedState().isCenteredY();
    }

    @Override
    public boolean intersects(float x, float y) {
        return this.modifiedState().intersects(x, y);
    }

    @Override
    public boolean intersects(Rect dim) {
        return this.modifiedState().intersects(dim);
    }

    @Override
    public boolean isHovered(InputProvider input) {
        return this.modifiedState().isHovered(input);
    }

    @Override
    public RectBuilder rebuild() {
        return this.modifiedState().rebuild();
    }

    public String toString() {
        return this.modifiedState.toString();
    }

    @Override
    public float centerX() {
        return this.modifiedState.centerX();
    }

    @Override
    public float centerY() {
        return this.modifiedState.centerY();
    }

    @Override
    public Pos2D center() {
        return this.modifiedState.center();
    }
}

