/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.ui.event;

import com.gildedgames.util.ui.event.GuiEvent;
import com.gildedgames.util.ui.input.InputProvider;
import com.gildedgames.util.ui.input.MouseInput;
import com.gildedgames.util.ui.input.MouseInputBehavior;
import com.gildedgames.util.ui.input.MouseInputPool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class MouseEvent
extends GuiEvent {
    private final Collection<MouseInput> eventList;
    private final List<MouseInputBehavior> behaviors = new ArrayList<MouseInputBehavior>();
    protected int scrollDifference;

    public MouseEvent(MouseInput ... events) {
        this.eventList = Arrays.asList(events);
    }

    public MouseEvent(List<MouseInput> events) {
        this.eventList = events;
    }

    @Override
    public void onMouseScroll(int scrollDifference, InputProvider input) {
        this.scrollDifference = scrollDifference;
    }

    public Collection<MouseInput> getEvents() {
        return this.eventList;
    }

    public Collection<MouseInputBehavior> getBehaviors() {
        return this.behaviors;
    }

    public void addBehavior(MouseInputBehavior behavior) {
        this.behaviors.add(behavior);
    }

    public boolean behaviorsMet(InputProvider input, MouseInputPool pool, int scrollDifference) {
        for (MouseInputBehavior behavior : this.behaviors) {
            if (behavior.isMet(input, pool, scrollDifference)) continue;
            return false;
        }
        return true;
    }
}

