/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.ui.graphics;

import com.gildedgames.util.ui.data.rect.Dim2D;
import com.gildedgames.util.ui.data.rect.ModDim2D;
import com.gildedgames.util.ui.data.rect.Rect;
import com.gildedgames.util.ui.data.rect.RectHolder;
import com.gildedgames.util.ui.graphics.Sprite;
import com.gildedgames.util.ui.graphics.UVBehavior;
import java.util.ArrayList;
import java.util.List;

public class ResizableUVBehavior
implements UVBehavior {
    private final Sprite.UV topLeftCorner;
    private final Sprite.UV topRightCorner;
    private final Sprite.UV bottomLeftCorner;
    private final Sprite.UV bottomRightCorner;
    private final Sprite.UV leftSide;
    private final Sprite.UV topSide;
    private final Sprite.UV rightSide;
    private final Sprite.UV bottomSide;
    private final Sprite.UV center;
    private final List<UVBehavior.UVDimPair> drawnUVs = new ArrayList<UVBehavior.UVDimPair>();
    private Rect lastAreaToDraw;

    public ResizableUVBehavior(Sprite.UV cornersArea, Sprite.UV verticalArea, Sprite.UV horizontalArea) {
        this.topLeftCorner = cornersArea.clone().min(0.0f, 0.0f).flush();
        this.topRightCorner = cornersArea.clone().min(this.topLeftCorner.width() + horizontalArea.width(), 0.0f).flush();
        this.bottomLeftCorner = cornersArea.clone().min(0.0f, this.topLeftCorner.height() + verticalArea.height()).flush();
        this.bottomRightCorner = cornersArea.clone().min(this.topLeftCorner.width() + horizontalArea.width(), this.topLeftCorner.height() + verticalArea.height()).flush();
        this.leftSide = verticalArea.clone().min(0.0f, this.topLeftCorner.height()).flush();
        this.rightSide = verticalArea.clone().min(this.topLeftCorner.width() + horizontalArea.width(), this.topRightCorner.height()).flush();
        this.topSide = horizontalArea.clone().min(this.topLeftCorner.width(), 0.0f).flush();
        this.bottomSide = horizontalArea.clone().min(this.topLeftCorner.width(), this.topLeftCorner.height() + verticalArea.height()).flush();
        float centerWidth = this.topRightCorner.minU() - this.topLeftCorner.maxU();
        float centerHeight = this.bottomRightCorner.minV() - this.topLeftCorner.maxV();
        this.center = Sprite.UV.build().min(this.topLeftCorner.maxU(), this.topLeftCorner.maxV()).area(centerWidth, centerHeight).flush();
    }

    @Override
    public List<UVBehavior.UVDimPair> getDrawnUVsFor(Sprite sprite, RectHolder areaToDraw) {
        return this.drawnUVs;
    }

    @Override
    public boolean shouldRecalculateUVs(Sprite sprite, RectHolder areaToDraw) {
        return this.lastAreaToDraw == null || this.lastAreaToDraw.width() != areaToDraw.dim().width() || this.lastAreaToDraw.height() != areaToDraw.dim().height();
    }

    @Override
    public void recalculateUVs(Sprite sprite, RectHolder areaToDraw) {
        float xStart;
        this.drawnUVs.clear();
        ModDim2D area = areaToDraw.dim();
        this.drawnUVs.add(new UVBehavior.UVDimPair(this.topLeftCorner, Dim2D.build().flush()));
        this.drawnUVs.add(new UVBehavior.UVDimPair(this.topRightCorner, Dim2D.build().x(area.width() - this.topRightCorner.width()).flush()));
        this.drawnUVs.add(new UVBehavior.UVDimPair(this.bottomLeftCorner, Dim2D.build().y(area.height() - this.topLeftCorner.height()).flush()));
        this.drawnUVs.add(new UVBehavior.UVDimPair(this.bottomRightCorner, Dim2D.build().x(area.width() - this.topRightCorner.width()).y(area.height() - this.topLeftCorner.height()).flush()));
        for (xStart = this.topLeftCorner.width(); xStart < area.width(); xStart += this.topSide.width()) {
            float width = Math.min(this.topSide.width(), area.width() - xStart - this.topRightCorner.width());
            this.drawnUVs.add(new UVBehavior.UVDimPair(this.topSide.clone().width(width).flush(), Dim2D.build().x(xStart).flush()));
            this.drawnUVs.add(new UVBehavior.UVDimPair(this.bottomSide.clone().width(width).flush(), Dim2D.build().y(area.height() - this.topLeftCorner.height()).x(xStart).flush()));
        }
        for (float yStart = this.topLeftCorner.height(); yStart < area.height(); yStart += this.leftSide.height()) {
            float height = Math.min(this.leftSide.height(), area.height() - yStart - this.bottomLeftCorner.height());
            this.drawnUVs.add(new UVBehavior.UVDimPair(this.leftSide.clone().height(height).flush(), Dim2D.build().y(yStart).flush()));
            this.drawnUVs.add(new UVBehavior.UVDimPair(this.rightSide.clone().height(height).flush(), Dim2D.build().x(area.width() - this.topLeftCorner.width()).y(yStart).flush()));
        }
        for (xStart = this.topLeftCorner.width(); xStart < area.width(); xStart += this.center.width()) {
            for (float yStart = this.topLeftCorner.height(); yStart < area.height(); yStart += this.center.height()) {
                float width = Math.min(this.center.width(), area.width() - xStart - this.topRightCorner.width());
                float height = Math.min(this.center.height(), area.height() - yStart - this.bottomLeftCorner.height());
                this.drawnUVs.add(new UVBehavior.UVDimPair(this.center.clone().width(width).height(height).flush(), Dim2D.build().x(xStart).y(yStart).flush()));
            }
        }
        this.lastAreaToDraw = areaToDraw.dim();
    }
}

