/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.ui.util;

import com.gildedgames.util.ui.UiCore;
import com.gildedgames.util.ui.common.GuiFrame;
import com.gildedgames.util.ui.graphics.Graphics2D;
import com.gildedgames.util.ui.input.InputProvider;
import org.lwjgl.opengl.GL11;

public class GuiCanvas
extends GuiFrame {
    private boolean disableDepth = true;
    private float depth;

    @Override
    public void initContent(InputProvider input) {
    }

    @Override
    public void draw(Graphics2D graphics, InputProvider input) {
        GL11.glPushMatrix();
        if (this.disableDepth) {
            GL11.glDisable((int)2929);
        } else {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)this.depth);
        }
        super.draw(graphics, input);
        if (this.disableDepth) {
            GL11.glEnable((int)2929);
        } else {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)this.depth);
        }
        GL11.glPopMatrix();
    }

    public <T extends GuiFrame> T get(String key) {
        return (T)((GuiFrame)this.content().get(key));
    }

    public <T extends GuiFrame> void set(String key, T obj) {
        if (this.content().get(key) != obj) {
            this.content().set(key, obj);
        }
    }

    public void remove(String key) {
        this.content().remove(key);
    }

    public <T extends GuiFrame> void remove(String key, T obj) {
        if (this.content().get(key) == obj) {
            this.content().remove(key);
        }
    }

    public static GuiCanvas fetch(String key) {
        return GuiCanvas.fetch(key, 0.0f);
    }

    public static GuiCanvas fetch(String key, float depth) {
        if (UiCore.locate().hasFrame()) {
            GuiFrame currentFrame = UiCore.locate().getCurrentFrame();
            if (!currentFrame.events().contains(key)) {
                currentFrame.events().set(key, new GuiCanvas());
            }
            GuiCanvas canvas = currentFrame.events().get(key, GuiCanvas.class);
            if (depth != 0.0f) {
                canvas.disableDepth = false;
                canvas.depth = depth;
            }
            return canvas;
        }
        return null;
    }
}

