/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.ui.util;

import com.gildedgames.util.ui.UiCore;
import com.gildedgames.util.ui.common.Gui;
import com.gildedgames.util.ui.common.GuiFrame;
import com.gildedgames.util.ui.data.Pos2D;
import com.gildedgames.util.ui.data.rect.Rect;
import com.gildedgames.util.ui.input.InputProvider;
import java.util.List;
import org.lwjgl.opengl.Display;

public class InputHelper {
    public static float prevMouseX;
    public static float prevMouseY;
    public static boolean prevResult;

    public static Pos2D cursorPos(InputProvider input) {
        return Pos2D.flush(input.getMouseX(), input.getMouseY());
    }

    public static boolean isHovered(InputCondition condition, InputProvider input) {
        if (prevMouseX != input.getMouseX() || prevMouseY != input.getMouseY()) {
            prevMouseX = input.getMouseX();
            prevMouseY = input.getMouseY();
            if (UiCore.locate().hasFrame()) {
                GuiFrame frame = UiCore.locate().getCurrentFrame();
                List<Gui> guis = frame.seekContent().queryAll(new Object[0]);
                guis.addAll(frame.events().queryAll(input));
                for (Gui gui : guis) {
                    if (!condition.isMet(gui) || !input.isHovered(gui.dim())) continue;
                    prevResult = true;
                    return true;
                }
            }
            prevResult = false;
            return false;
        }
        return prevResult;
    }

    public static boolean isInsideScreen(InputProvider input, Rect rect) {
        return !(rect.maxX() > input.getScreenWidth()) && !(rect.maxY() > input.getScreenHeight());
    }

    public static Pos2D convertToOpenGL(InputProvider input, Pos2D pos) {
        double heightScaleFactor = (float)Display.getHeight() / input.getScreenHeight();
        double widthScaleFactor = (float)Display.getWidth() / input.getScreenWidth();
        return Pos2D.flush((int)((double)pos.x() * widthScaleFactor), (int)((double)pos.y() * heightScaleFactor));
    }

    public static Pos2D getCenter(InputProvider input) {
        return Pos2D.flush(input.getScreenWidth() / 2.0f, input.getScreenHeight() / 2.0f);
    }

    public static Pos2D getBottomCenter(InputProvider input) {
        return InputHelper.getCenter(input).clone().addY(input.getScreenHeight() / 2.0f).flush();
    }

    public static Pos2D getBottomRight(InputProvider input) {
        return InputHelper.getBottomCenter(input).clone().addX(input.getScreenWidth() / 2.0f).flush();
    }

    public static Pos2D getBottomLeft(InputProvider input) {
        return InputHelper.getBottomRight(input).clone().addX(-input.getScreenWidth()).flush();
    }

    public static Pos2D getCenterLeft(InputProvider input) {
        return InputHelper.getCenter(input).clone().addX(-input.getScreenWidth() / 2.0f).flush();
    }

    public static Pos2D getCenterRight(InputProvider input) {
        return InputHelper.getCenterLeft(input).clone().addX(input.getScreenWidth()).flush();
    }

    public static Pos2D getTopCenter(InputProvider input) {
        return InputHelper.getCenter(input).clone().addY(-input.getScreenHeight() / 2.0f).flush();
    }

    public static Pos2D getTopLeft(InputProvider input) {
        return InputHelper.getTopCenter(input).clone().addX(-input.getScreenWidth() / 2.0f).flush();
    }

    public static Pos2D getTopRight(InputProvider input) {
        return InputHelper.getTopLeft(input).clone().addX(input.getScreenWidth()).flush();
    }

    public static interface InputCondition {
        public boolean isMet(Gui var1);
    }
}

