/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.ui.util;

import com.gildedgames.util.ui.common.GuiFrame;
import com.gildedgames.util.ui.data.rect.Dim2D;
import com.gildedgames.util.ui.data.rect.Rect;
import com.gildedgames.util.ui.input.InputProvider;
import com.gildedgames.util.ui.util.Text;
import com.gildedgames.util.ui.util.TextElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TextBox
extends GuiFrame {
    private Text[] text;
    private boolean centerFormat;

    public TextBox(Rect dim, boolean centerFormat, Text ... text) {
        super(dim);
        this.text = text;
        this.centerFormat = centerFormat;
    }

    public void setText(Text ... text) {
        this.text = text;
    }

    @Override
    public void initContent(InputProvider input) {
        int i = 0;
        int textHeight = 0;
        float halfWidth = this.dim().width() / 2.0f;
        for (Text t : this.text) {
            if (t.text == null || t.text.isEmpty()) continue;
            String[] strings = t.text.split("/n");
            ArrayList stringList = new ArrayList(strings.length);
            Collections.addAll(stringList, strings);
            for (String string : stringList) {
                List<String> newStrings = t.font.splitStringsIntoArea(string, (int)(this.dim().width() / t.scale));
                for (String s : newStrings) {
                    TextElement textElement = this.centerFormat ? new TextElement(new Text(s, t.drawingData.getColor(), t.scale, t.font), Dim2D.build().pos(halfWidth, textHeight).centerX(true).flush()) : new TextElement(new Text(s, t.drawingData.getColor(), t.scale, t.font), Dim2D.build().pos(0.0f, textHeight).flush());
                    this.content().set(String.valueOf(i), textElement);
                    textHeight = (int)((float)textHeight + 1.2f * t.scaledHeight());
                    ++i;
                }
            }
        }
        this.dim().mod().height(textHeight).flush();
    }
}

