/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.ui.util.events.slots;

import com.gildedgames.util.ui.common.GuiFrame;
import com.gildedgames.util.ui.data.rect.RectModifier;
import com.gildedgames.util.ui.event.GuiEvent;
import com.gildedgames.util.ui.graphics.Graphics2D;
import com.gildedgames.util.ui.input.ButtonState;
import com.gildedgames.util.ui.input.InputProvider;
import com.gildedgames.util.ui.input.MouseInputPool;
import com.gildedgames.util.ui.util.GuiCanvas;
import com.gildedgames.util.ui.util.events.DragBehavior;
import com.gildedgames.util.ui.util.events.slots.SlotParser;
import com.gildedgames.util.ui.util.events.slots.SlotStack;
import com.gildedgames.util.ui.util.events.slots.SlotStackFactory;
import com.gildedgames.util.ui.util.factory.Factory;
import com.google.common.base.Function;

public class SlotBehavior<T>
extends GuiEvent<GuiFrame> {
    private SlotStack<T> slotContents;
    private SlotParser<T> parser;
    private boolean takenContentsOut;

    public SlotBehavior(SlotParser<T> parser) {
        this.parser = parser;
    }

    public void setSlotContents(SlotStack<T> draggedState) {
        this.setSlotContents(draggedState, true);
    }

    public void clearSlotContents() {
        this.slotContents = null;
        this.content().remove("slotContents");
        this.parser.onContentsChange(this, null);
    }

    public void setSlotContents(SlotStack<T> draggedState, boolean notifyParser) {
        if (draggedState == null) {
            return;
        }
        if (notifyParser && !this.parser.isAllowed(draggedState)) {
            return;
        }
        this.slotContents = draggedState;
        this.slotContents.dim().clear(RectModifier.ModifierType.POS);
        this.slotContents.dim().mod().resetPos().x(((GuiFrame)this.getGui()).dim().width() / 2.0f).y(((GuiFrame)this.getGui()).dim().height() / 2.0f).center(true).flush();
        this.content().set("slotContents", this.slotContents);
        if (notifyParser) {
            this.parser.onContentsChange(this, this.slotContents);
        }
    }

    public SlotStack<T> getSlotContents() {
        return this.slotContents;
    }

    @Override
    public void draw(Graphics2D graphics, InputProvider input) {
        super.draw(graphics, input);
        if (this.slotContents != null) {
            this.slotContents.dim().mod().center(true).flush();
        }
    }

    @Override
    public void onMouseInput(MouseInputPool pool, InputProvider input) {
        SlotStack stack;
        Object draggedObject;
        GuiCanvas canvas;
        if (input.isHovered(((GuiFrame)this.getGui()).dim()) && pool.has(ButtonState.PRESS) && this.parser.onMouseInput(pool, input)) {
            return;
        }
        super.onMouseInput(pool, input);
        if (!this.takenContentsOut && pool.has(ButtonState.PRESS) && input.isHovered(((GuiFrame)this.getGui()).dim()) && (canvas = GuiCanvas.fetch("dragCanvas", 550.0f)) != null && (draggedObject = canvas.get("draggedObject")) instanceof SlotStack && (stack = (SlotStack)draggedObject).events().contains("dragBehavior")) {
            SlotStack<T> original = this.getSlotContents();
            stack.events().remove("dragBehavior");
            this.setSlotContents(stack);
            canvas.remove("draggedObject");
            if (original != null) {
                original.events().set("dragBehavior", new DragBehavior(), original);
                canvas.set("draggedObject", original);
            }
        }
        this.takenContentsOut = false;
    }

    @Override
    public void initEvent() {
        Function iconFactory = new Function<T, GuiFrame>(){

            public GuiFrame apply(T input) {
                return SlotBehavior.this.getSlotContents();
            }
        };
        Factory dataFunction = new Factory<T>(){

            @Override
            public T create() {
                return SlotBehavior.this.getSlotContents().getData();
            }
        };
        ((GuiFrame)this.getGui()).events().set("dragFactory", new SlotStackFactory<T>(iconFactory, dataFunction){

            @Override
            public boolean shouldRemoveDragged(SlotStack<T> createdStack) {
                return false;
            }

            @Override
            public boolean isActive(MouseInputPool pool, InputProvider input) {
                return SlotBehavior.this.getSlotContents() != null && (!input.isHovered(this.getGui().dim()) || !SlotBehavior.this.parser.onMouseInput(pool, input));
            }

            @Override
            public void onCreateDraggedState() {
                SlotBehavior.this.takenContentsOut = true;
                SlotBehavior.this.slotContents = null;
                SlotBehavior.this.content().remove("slotContents");
                SlotBehavior.this.parser.onContentsChange(SlotBehavior.this, null);
            }
        });
    }
}

