/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.ui.util.filebrowser;

import com.gildedgames.util.core.gui.util.wrappers.MinecraftTextBackground;
import com.gildedgames.util.ui.common.GuiFrame;
import com.gildedgames.util.ui.event.view.MouseEventGui;
import com.gildedgames.util.ui.graphics.Graphics2D;
import com.gildedgames.util.ui.input.ButtonState;
import com.gildedgames.util.ui.input.InputProvider;
import com.gildedgames.util.ui.input.MouseButton;
import com.gildedgames.util.ui.input.MouseInput;
import com.gildedgames.util.ui.input.MouseInputPool;
import com.gildedgames.util.ui.util.InputHelper;
import com.gildedgames.util.ui.util.filebrowser.DropdownEntry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class DropdownMenu
extends GuiFrame {
    private DropdownEntry[] entries;
    private List<GuiFrame> backgrounds = new ArrayList<GuiFrame>();

    public DropdownMenu(DropdownEntry ... entries) {
        this.entries = entries;
    }

    @Override
    public void initContent(InputProvider input) {
        int count = 0;
        float lastHeight = 0.0f;
        float maxWidth = 0.0f;
        this.backgrounds.clear();
        for (final DropdownEntry entry : this.entries) {
            GuiFrame visuals = entry.createVisuals();
            final MinecraftTextBackground background = new MinecraftTextBackground(visuals.dim().clone().mod().center(false).pos(0.0f, lastHeight).addArea(5.0f, 6.0f).flush());
            visuals.dim().mod().center(false).pos(3.0f, lastHeight + 3.0f).flush();
            background.events().set("click", new MouseEventGui(new MouseInput[]{new MouseInput(MouseButton.LEFT, ButtonState.PRESS)}){
                private int originalColor;
                {
                    super(events);
                    this.originalColor = background.getBorderColor();
                }

                @Override
                public void draw(Graphics2D graphics, InputProvider input) {
                    if (input.isHovered(background)) {
                        background.setBorderColor(new Color(0, 100, 255, 100).getRGB());
                        entry.onHover(InputHelper.cursorPos(input));
                    } else {
                        background.setBorderColor(this.originalColor);
                    }
                    super.draw(graphics, input);
                }

                @Override
                protected void onTrue(InputProvider input, MouseInputPool pool) {
                    entry.onOpen();
                }

                @Override
                protected void onFalse(InputProvider input, MouseInputPool pool) {
                }

                @Override
                public void initEvent() {
                }
            });
            this.content().set("entry" + count, background);
            this.content().set("entryVisuals" + count, visuals);
            lastHeight += background.dim().height();
            maxWidth = Math.max(maxWidth, visuals.dim().width() + 5.0f);
            this.backgrounds.add(background);
            ++count;
        }
        for (GuiFrame back : this.backgrounds) {
            back.dim().mod().width(maxWidth).flush();
        }
    }
}

