/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.ui.util.input;

import com.gildedgames.util.core.gui.util.GuiFactory;
import com.gildedgames.util.core.gui.util.MinecraftAssetLocation;
import com.gildedgames.util.ui.common.Gui;
import com.gildedgames.util.ui.common.GuiFrame;
import com.gildedgames.util.ui.data.AssetLocation;
import com.gildedgames.util.ui.data.rect.Dim2D;
import com.gildedgames.util.ui.data.rect.Rect;
import com.gildedgames.util.ui.data.rect.RectModifier;
import com.gildedgames.util.ui.event.GuiEvent;
import com.gildedgames.util.ui.event.view.MouseEventGui;
import com.gildedgames.util.ui.graphics.Sprite;
import com.gildedgames.util.ui.input.ButtonState;
import com.gildedgames.util.ui.input.InputProvider;
import com.gildedgames.util.ui.input.KeyboardInput;
import com.gildedgames.util.ui.input.KeyboardInputPool;
import com.gildedgames.util.ui.input.MouseButton;
import com.gildedgames.util.ui.input.MouseInput;
import com.gildedgames.util.ui.input.MouseInputPool;
import com.gildedgames.util.ui.util.TextElement;
import com.gildedgames.util.ui.util.TextureElement;
import com.gildedgames.util.ui.util.input.DataInput;
import java.awt.Color;
import net.minecraft.util.ChatAllowedCharacters;

public class GuiInput<T>
extends GuiFrame {
    private DataInput<T> data;
    private final AssetLocation texture = new MinecraftAssetLocation("gilded-games-util", "textures/gui/test/inputBox.png");
    private final AssetLocation cursorTexture = new MinecraftAssetLocation("gilded-games-util", "textures/gui/test/inputCursor.png");
    private boolean isClicked;
    private TextElement input;
    private TextElement text;
    private String title;
    private String initContent;
    private int textIndex;
    private int cursorIndex;

    public GuiInput(DataInput<T> data, Rect rect, String title) {
        this(data, rect, title, "");
    }

    public GuiInput(DataInput<T> data, Rect rect, String title, String initContent) {
        this.data = data;
        this.data.setData(this.data.parse(initContent));
        this.dim().mod().set(rect).flush();
        this.title = title;
        this.initContent = initContent;
    }

    @Override
    public void initContent(InputProvider input) {
        super.initContent(input);
        this.text = new TextElement(GuiFactory.text(this.title, Color.WHITE), Dim2D.build().x(this.dim().width() / 2.0f).centerX(true).flush());
        TextureElement inputBox = GuiFactory.createResizableTexture(this.texture, this.dim().clone().clear(RectModifier.ModifierType.POS).mod().pos(0.0f, this.text.dim().height()).flush(), Sprite.UV.build().area(1.0f, 1.0f).flush(), Sprite.UV.build().area(1.0f, 18.0f).flush(), Sprite.UV.build().area(198.0f, 1.0f).flush());
        this.input = new TextElement(GuiFactory.text(this.initContent, Color.WHITE), Dim2D.build().pos(2.0f, this.text.dim().height() + inputBox.dim().height() / 2.0f).centerY(true).flush());
        final TextureElement cursor = GuiFactory.createResizableTexture(this.cursorTexture, Dim2D.build().width(1.0f).height(this.text.getText().font().getHeight("h")).flush(), Sprite.UV.build().area(1.0f, 1.0f).flush(), Sprite.UV.build().area(1.0f, 1.0f).flush(), Sprite.UV.build().area(1.0f, 1.0f).flush());
        cursor.dim().mod().y(13.0f).x(2.0f).flush();
        cursor.setVisible(false);
        this.input.events().set("onTyping", new GuiEvent<Gui>(){

            @Override
            public boolean onKeyboardInput(KeyboardInputPool pool, InputProvider input) {
                boolean flag = GuiInput.this.isClicked;
                if (GuiInput.this.isClicked && pool.has(ButtonState.PRESS)) {
                    TextElement text = GuiInput.this.input;
                    if (pool.has(14) && text.getData().length() > 0) {
                        text.setData(text.getData().substring(0, text.getData().length() - 1));
                        GuiInput.this.data.setData(GuiInput.this.data.parse(text.getData()));
                    }
                    for (KeyboardInput key : pool) {
                        if (!ChatAllowedCharacters.func_71566_a((char)key.getChar())) continue;
                        String keyString = String.valueOf(key.getChar());
                        String newString = text.getData().concat(keyString);
                        if (!GuiInput.this.data.validString(newString)) continue;
                        GuiInput.this.data.setData(GuiInput.this.data.parse(newString));
                        text.setData(newString);
                    }
                    cursor.dim().mod().x(text.getText().font().getWidth(text.getData()) + 2.0f).flush();
                }
                super.onKeyboardInput(pool, input);
                return flag;
            }

            @Override
            public void initEvent() {
            }
        });
        inputBox.events().set("clicking", new MouseEventGui(new MouseInput[]{new MouseInput(MouseButton.LEFT, ButtonState.PRESS)}){

            @Override
            protected void onTrue(InputProvider input, MouseInputPool pool) {
                GuiInput.this.isClicked = true;
                cursor.setVisible(true);
            }

            @Override
            protected void onFalse(InputProvider input, MouseInputPool pool) {
                if (!input.isHovered(this.getGui().dim())) {
                    GuiInput.this.isClicked = false;
                    cursor.setVisible(false);
                }
            }

            @Override
            public void initEvent() {
            }
        });
        this.content().set("inputBox", inputBox);
        this.content().set("text", this.text);
        this.content().set("input", this.input);
        this.content().set("cursor", cursor);
        this.dim().mod().addHeight(this.text.dim().height()).flush();
    }

    public T getData() {
        return this.data.getData();
    }
}

