/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.gui;

import com.mumfrey.liteloader.api.ModInfoDecorator;
import com.mumfrey.liteloader.client.gui.GuiLiteLoaderPanel;
import com.mumfrey.liteloader.client.gui.ModListEntry;
import com.mumfrey.liteloader.client.util.GLClippingPlanes;
import com.mumfrey.liteloader.core.ModInfo;
import com.mumfrey.liteloader.util.render.IconClickable;
import com.mumfrey.liteloader.util.render.IconTextured;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class GuiModListPanel
extends bbw {
    static final int BLACK = -16777216;
    static final int DARK_GREY = -1338821837;
    static final int GREY = -6710887;
    static final int WHITE = -1;
    static final int BLEND_2THRDS = -1325400065;
    static final int BLEND_HALF = -2130706433;
    static final int API_COLOUR = -5635926;
    static final int EXTERNAL_ENTRY_COLOUR = -12070486;
    static final int MISSING_DEPENDENCY_COLOUR = -22016;
    static final int ERROR_COLOUR = -43691;
    static final int ERROR_GRADIENT_COLOUR = -5636096;
    static final int ERROR_GRADIENT_COLOUR2 = -11206656;
    static final int VERSION_TEXT_COLOUR = -6710887;
    static final int GRADIENT_COLOUR2 = -1338821837;
    static final int HANGER_COLOUR = -6710887;
    static final int HANGER_COLOUR_MOUSEOVER = -1;
    static final int PANEL_HEIGHT = 32;
    static final int PANEL_SPACING = 4;
    private ModListEntry owner;
    private final bbu fontRenderer;
    private final int brandColour;
    private final List<ModInfoDecorator> decorators;
    private final ModInfo<?> modInfo;
    private boolean mouseOver;
    private IconClickable mouseOverIcon = null;
    private List<IconTextured> modIcons = new ArrayList<IconTextured>();

    public GuiModListPanel(ModListEntry owner, bbu fontRenderer, int brandColour, ModInfo<?> modInfo, List<ModInfoDecorator> decorators) {
        this.owner = owner;
        this.fontRenderer = fontRenderer;
        this.brandColour = brandColour;
        this.modInfo = modInfo;
        this.decorators = decorators;
        for (ModInfoDecorator decorator : this.decorators) {
            decorator.addIcons(modInfo, this.modIcons);
        }
    }

    public int draw(int mouseX, int mouseY, float partialTicks, int xPosition, int yPosition, int width, boolean selected) {
        int gradientColour = this.getGradientColour(selected);
        int titleColour = this.getTitleColour(selected);
        int statusColour = this.getStatusColour(selected);
        this.a(xPosition, yPosition, xPosition + width, yPosition + 32, gradientColour, -1338821837);
        String titleText = this.owner.getTitleText();
        String versionText = this.owner.getVersionText();
        String statusText = this.owner.getStatusText();
        for (ModInfoDecorator decorator : this.decorators) {
            String newStatusText = decorator.modifyStatusText(this.modInfo, statusText);
            if (newStatusText == null) continue;
            statusText = newStatusText;
        }
        this.fontRenderer.b(titleText, xPosition + 5, yPosition + 2, titleColour);
        this.fontRenderer.b(versionText, xPosition + 5, yPosition + 12, -6710887);
        this.fontRenderer.b(statusText, xPosition + 5, yPosition + 22, statusColour);
        this.mouseOver = this.isMouseOver(mouseX, mouseY, xPosition, yPosition, width, 32);
        int hangerColour = this.mouseOver ? -1 : -6710887;
        GuiModListPanel.a((int)xPosition, (int)yPosition, (int)(xPosition + 1), (int)(yPosition + 32), (int)hangerColour);
        for (ModInfoDecorator decorator : this.decorators) {
            decorator.onDrawListEntry(mouseX, mouseY, partialTicks, xPosition, yPosition, width, 32, selected, this.modInfo, gradientColour, titleColour, statusColour);
        }
        return 36;
    }

    public int postRender(int mouseX, int mouseY, float partialTicks, int xPosition, int yPosition, int width, boolean selected) {
        xPosition += width - 14;
        yPosition += 18;
        this.mouseOverIcon = null;
        for (IconTextured icon : this.modIcons) {
            xPosition = this.drawPropertyIcon(xPosition, yPosition, icon, mouseX, mouseY);
        }
        return 36;
    }

    protected int drawPropertyIcon(int xPosition, int yPosition, IconTextured icon, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bao.B().P().a(icon.getTextureResource());
        GL11.glEnable((int)3042);
        this.b(xPosition, yPosition, icon.getUPos(), icon.getVPos(), icon.a(), icon.b());
        GL11.glDisable((int)3042);
        if (mouseX >= xPosition && mouseX <= xPosition + 12 && mouseY >= yPosition && mouseY <= yPosition + 12) {
            String tooltipText = icon.getDisplayText();
            if (tooltipText != null) {
                GLClippingPlanes.glDisableClipping();
                GuiLiteLoaderPanel.drawTooltip(this.fontRenderer, tooltipText, mouseX, mouseY, 4096, 4096, -1, Integer.MIN_VALUE);
                GLClippingPlanes.glEnableClipping();
            }
            if (icon instanceof IconClickable) {
                this.mouseOverIcon = (IconClickable)icon;
            }
        }
        return xPosition - 14;
    }

    protected int getGradientColour(boolean selected) {
        return 0xB0FFFFFF & (this.owner.isErrored() ? (selected ? -5636096 : -11206656) : (selected ? (this.owner.isExternal() ? -12070486 : this.brandColour) : -16777216));
    }

    protected int getTitleColour(boolean selected) {
        if (this.owner.isMissingDependencies()) {
            return -22016;
        }
        if (this.owner.isMissingAPIs()) {
            return -5635926;
        }
        if (this.owner.isErrored()) {
            return -43691;
        }
        if (!this.owner.isActive()) {
            return -6710887;
        }
        return this.owner.isExternal() ? -12070486 : -1;
    }

    protected int getStatusColour(boolean selected) {
        return this.owner.isExternal() ? -12070486 : this.brandColour;
    }

    public int getHeight() {
        return 36;
    }

    private boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX > x && mouseX < x + width && mouseY > y && mouseY < y + height;
    }

    public boolean isMouseOverIcon() {
        return this.mouseOver && this.mouseOverIcon != null;
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    public void iconClick(Object source) {
        if (this.mouseOverIcon != null) {
            this.mouseOverIcon.onClicked(source, (Object)this);
        }
    }
}

