/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.util.log;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingFormatArgumentException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.helpers.Booleans;

public class LiteLoaderLogger
extends AbstractAppender {
    public static final boolean DEBUG = Booleans.parseBoolean((String)System.getProperty("liteloader.debug"), (boolean)false);
    private static final int LOG_TAIL_SIZE = 500;
    private static Logger logger = (Logger)LogManager.getLogger((String)"LiteLoader");
    private static LinkedList<String> logTail = new LinkedList();
    private static long logIndex = 0L;
    private static Throwable lastThrowable;

    protected LiteLoaderLogger() {
        super("Internal Log Appender", null, null);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LogEvent event) {
        LinkedList<String> linkedList = logTail;
        synchronized (linkedList) {
            ++logIndex;
            this.append(event.getTimeMillis(), event.getMessage().getFormattedMessage());
            Throwable thrown = event.getThrown();
            if (thrown != null) {
                this.append(event.getTimeMillis(), String.format("\u00a74%s: \u00a76%s", thrown.getClass().getSimpleName(), thrown.getMessage()));
            }
        }
    }

    private void append(long timestamp, String message) {
        String date = new SimpleDateFormat("[HH:mm:ss] ").format(new Date(timestamp));
        while (message.indexOf(10) > -1) {
            int LF = message.indexOf(10);
            this.appendLine(date + message.substring(0, LF));
            message = message.substring(LF + 1);
        }
        this.appendLine(date + message);
    }

    private void appendLine(String line) {
        logTail.add(line);
        if (logTail.size() > 500) {
            logTail.remove();
        }
    }

    public static long getLogIndex() {
        return logIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getLogTail() {
        ArrayList<String> log = new ArrayList<String>();
        LinkedList<String> linkedList = logTail;
        synchronized (linkedList) {
            log.addAll(logTail);
        }
        return log;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void clearLastThrowable() {
        lastThrowable = null;
    }

    public static Throwable getLastThrowable() {
        Throwable lastThrowableWrapped = null;
        if (lastThrowable != null) {
            StringWriter sw = new StringWriter();
            lastThrowable.printStackTrace(new PrintWriter(sw));
            lastThrowableWrapped = new Throwable(sw.toString());
            try {
                sw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return lastThrowableWrapped;
    }

    private static void log(Level level, String format, Object ... data) {
        try {
            logger.log(level, String.format(format, data));
        }
        catch (MissingFormatArgumentException ex) {
            logger.log(level, format.replace('%', '@'));
        }
    }

    private static void log(Level level, Throwable th, String format, Object ... data) {
        lastThrowable = th;
        try {
            logger.log(level, String.format(format, data), th);
        }
        catch (LinkageError ex) {
            th.printStackTrace();
        }
        catch (Throwable th2) {
            th2.initCause(th);
            th2.printStackTrace();
        }
    }

    public static void severe(String format, Object ... data) {
        LiteLoaderLogger.log(Level.ERROR, format, data);
    }

    public static void severe(Throwable th, String format, Object ... data) {
        lastThrowable = th;
        try {
            LiteLoaderLogger.log(Level.ERROR, th, format, data);
        }
        catch (LinkageError ex) {
            th.printStackTrace();
        }
        catch (Throwable th2) {
            th2.initCause(th);
            th2.printStackTrace();
        }
    }

    public static void warning(String format, Object ... data) {
        LiteLoaderLogger.log(Level.WARN, format, data);
    }

    public static void warning(Throwable th, String format, Object ... data) {
        lastThrowable = th;
        try {
            LiteLoaderLogger.log(Level.WARN, th, format, data);
        }
        catch (LinkageError ex) {
            th.printStackTrace();
        }
        catch (Throwable th2) {
            th2.initCause(th);
            th2.printStackTrace();
        }
    }

    public static void info(String format, Object ... data) {
        LiteLoaderLogger.log(Level.INFO, format, data);
    }

    public static void debug(String format, Object ... data) {
        if (DEBUG) {
            System.err.print("[DEBUG] ");
            System.err.println(String.format(format, data));
        }
    }

    public static void debug(Throwable th, String format, Object ... data) {
        if (DEBUG) {
            th.printStackTrace();
            LiteLoaderLogger.debug(format, data);
        }
    }

    public static void debug(Throwable th) {
        if (DEBUG) {
            th.printStackTrace();
        }
    }

    static {
        logger.addAppender((Appender)new LiteLoaderLogger());
    }
}

