/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.ae2.container.slot;

import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.container.ContainerNull;
import appeng.container.slot.SlotCraftingTerm;
import appeng.helpers.IContainerCraftingPacket;
import appeng.helpers.InventoryAction;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorPlayerHand;
import appeng.util.item.AEItemStack;
import appeng.util.prioitylist.IPartitionList;
import appeng.util.prioitylist.MergedPriorityList;
import by.fxg.mwicontent.ae2.util.PatternDetailsExtCrafting;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public class SlotCraftingTerminalExtCrafting
extends SlotCraftingTerm {
    private final EntityPlayer player;
    private final BaseActionSource machineSource;
    private final IEnergySource energySource;
    private final IStorageMonitorable storage;
    private final IInventory patternGrid;
    private final IInventory craftingGrid;
    private final int gridWidth;
    private final int gridHeight;

    public SlotCraftingTerminalExtCrafting(EntityPlayer player, BaseActionSource machineSource, IEnergySource energySource, IStorageMonitorable storage, IInventory patternGrid, IInventory craftingGrid, IInventory invOutput, int x, int y, IContainerCraftingPacket ccp, int gridWidth, int gridHeight) {
        super(player, machineSource, energySource, storage, patternGrid, craftingGrid, invOutput, x, y, ccp);
        this.player = player;
        this.machineSource = machineSource;
        this.energySource = energySource;
        this.storage = storage;
        this.patternGrid = patternGrid;
        this.craftingGrid = craftingGrid;
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
    }

    public void func_82870_a(EntityPlayer player, ItemStack stack) {
        FMLCommonHandler.instance().firePlayerCraftingEvent(player, stack, this.craftingGrid);
        this.func_75208_c(stack);
        for (int slot = 0; slot < this.craftingGrid.func_70302_i_(); ++slot) {
            ItemStack stackInSlot = this.craftingGrid.func_70301_a(slot);
            if (stackInSlot == null) continue;
            this.craftingGrid.func_70298_a(slot, 1);
            if (!stackInSlot.func_77973_b().hasContainerItem(stackInSlot)) continue;
            ItemStack stackContainer = stackInSlot.func_77973_b().getContainerItem(stackInSlot);
            if (stackContainer != null && stackContainer.func_77984_f() && stackContainer.func_77960_j() > stackContainer.func_77958_k()) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(this.player, stackContainer));
                continue;
            }
            if (stackInSlot.func_77973_b().func_77630_h(stackInSlot) && this.player.field_71071_by.func_70441_a(stackContainer)) continue;
            if (this.craftingGrid.func_70301_a(slot) == null) {
                this.craftingGrid.func_70299_a(slot, stackContainer);
                continue;
            }
            this.player.func_71019_a(stackContainer, false);
        }
    }

    public void doClick(InventoryAction action, EntityPlayer player) {
        if (this.func_75211_c() == null) {
            return;
        }
        if (Platform.isClient()) {
            return;
        }
        IMEMonitor monitor = this.storage.getItemInventory();
        int howManyPerCraft = this.func_75211_c().field_77994_a;
        int maxTimesToCraft = 0;
        InventoryAdaptor invAdaptor = null;
        if (action == InventoryAction.CRAFT_SHIFT) {
            invAdaptor = InventoryAdaptor.getAdaptor((Object)player, null);
            maxTimesToCraft = (int)Math.floor((double)this.func_75211_c().func_77976_d() / (double)howManyPerCraft);
        } else if (action == InventoryAction.CRAFT_STACK) {
            invAdaptor = new AdaptorPlayerHand(player);
            maxTimesToCraft = (int)Math.floor((double)this.func_75211_c().func_77976_d() / (double)howManyPerCraft);
        } else {
            invAdaptor = new AdaptorPlayerHand(player);
            maxTimesToCraft = 1;
        }
        maxTimesToCraft = this.capCraftingAttempts(maxTimesToCraft);
        if (invAdaptor == null) {
            return;
        }
        ItemStack stackClonedRS = Platform.cloneItemStack((ItemStack)this.func_75211_c());
        if (stackClonedRS == null) {
            return;
        }
        for (int slot = 0; slot < maxTimesToCraft; ++slot) {
            IItemList all;
            ItemStack stackExtra;
            if (invAdaptor.simulateAdd(stackClonedRS) != null || (stackExtra = invAdaptor.addItems(this.craftItem(player, stackClonedRS, (IMEMonitor<IAEItemStack>)monitor, (IItemList<IAEItemStack>)(all = monitor.getStorageList())))) == null) continue;
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(stackExtra);
            Platform.spawnDrops((World)player.field_70170_p, (int)((int)player.field_70165_t), (int)((int)player.field_70163_u), (int)((int)player.field_70161_v), drops);
            return;
        }
    }

    private int capCraftingAttempts(int maxTimesToCraft) {
        return maxTimesToCraft;
    }

    private ItemStack craftItem(EntityPlayer player, ItemStack stackRequested, IMEMonitor<IAEItemStack> monitor, IItemList<IAEItemStack> all) {
        ItemStack stack = this.func_75211_c();
        if (stack != null && Platform.isSameItem((ItemStack)stackRequested, (ItemStack)stack)) {
            ItemStack[] set = new ItemStack[this.patternGrid.func_70302_i_()];
            if (Platform.isServer()) {
                InventoryCrafting invCrafting = new InventoryCrafting((Container)new ContainerNull(), this.gridWidth, this.gridHeight);
                for (int slot = 0; slot < this.gridWidth * this.gridHeight; ++slot) {
                    invCrafting.func_70299_a(slot, this.patternGrid.func_70301_a(slot));
                }
                IRecipe recipe = PatternDetailsExtCrafting.findMatchingRecipe(invCrafting, player.field_70170_p);
                if (recipe == null) {
                    Item target = stackRequested.func_77973_b();
                    if (target.func_77645_m() && target.isRepairable()) {
                        boolean isBad = false;
                        for (int slot = 0; slot < invCrafting.func_70302_i_(); ++slot) {
                            ItemStack pis = invCrafting.func_70301_a(slot);
                            if (pis == null || pis.func_77973_b() == target) continue;
                            isBad = true;
                        }
                        if (!isBad) {
                            this.func_82870_a(player, stack);
                            player.field_71070_bA.func_75130_a(this.craftingGrid);
                            return stackRequested;
                        }
                    }
                    return null;
                }
                stack = recipe.func_77572_b(invCrafting);
                if (monitor != null) {
                    for (int slot = 0; slot < this.patternGrid.func_70302_i_(); ++slot) {
                        if (this.patternGrid.func_70301_a(slot) == null) continue;
                        set[slot] = Platform.extractItemsByRecipe((IEnergySource)this.energySource, (BaseActionSource)this.machineSource, monitor, (World)player.field_70170_p, (IRecipe)recipe, (ItemStack)stack, (InventoryCrafting)invCrafting, (ItemStack)this.patternGrid.func_70301_a(slot), (int)slot, all, (Actionable)Actionable.MODULATE, (IPartitionList)new MergedPriorityList());
                        invCrafting.func_70299_a(slot, set[slot]);
                    }
                }
            }
            if (this.preCraft(player, monitor, set, stack)) {
                this.makeItem(player, stack);
                this.postCraft(player, monitor, set, stack);
            }
            player.field_71070_bA.func_75130_a(this.craftingGrid);
            return stack;
        }
        return null;
    }

    private boolean preCraft(EntityPlayer player, IMEMonitor<IAEItemStack> monitor, ItemStack[] set, ItemStack result) {
        return true;
    }

    private void makeItem(EntityPlayer player, ItemStack stack) {
        this.func_82870_a(player, stack);
    }

    private void postCraft(EntityPlayer player, IMEMonitor<IAEItemStack> monitor, ItemStack[] set, ItemStack result) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (Platform.isServer()) {
            for (int slot = 0; slot < this.craftingGrid.func_70302_i_(); ++slot) {
                IAEItemStack fail;
                if (this.craftingGrid.func_70301_a(slot) == null) {
                    this.craftingGrid.func_70299_a(slot, set[slot]);
                    continue;
                }
                if (set[slot] == null || (fail = (IAEItemStack)monitor.injectItems((IAEStack)AEItemStack.create((ItemStack)set[slot]), Actionable.MODULATE, this.machineSource)) == null) continue;
                drops.add(fail.getItemStack());
            }
        }
        if (drops.size() > 0) {
            Platform.spawnDrops((World)player.field_70170_p, (int)((int)player.field_70165_t), (int)((int)player.field_70163_u), (int)((int)player.field_70161_v), drops);
        }
    }
}

