/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.ae2.items.patterns;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.localization.GuiText;
import appeng.util.Platform;
import by.fxg.mwicontent.ae2.ContentAE2Config;
import by.fxg.mwicontent.ae2.items.patterns.ItemBasicCraftingPattern;
import by.fxg.mwicontent.ae2.util.PatternDetailsMagical;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemCraftingPatternMagical
extends ItemBasicCraftingPattern {
    private static final int SUBTYPES = 4;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemCraftingPatternMagical() {
        super("itemCraftingPatternMagical");
        this.func_77627_a(true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.icons = new IIcon[4];
        for (int i = 0; i != this.icons.length; ++i) {
            this.icons[i] = register.func_94245_a("mwi:ae2/itemCraftingPatternMagical" + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return damage > -1 && damage < this.icons.length ? this.icons[damage] : this.icons[0];
    }

    protected void getCheckedSubItems(Item sameItem, CreativeTabs creativeTab, List<ItemStack> itemStacks) {
        for (int i = 0; i != 4; ++i) {
            itemStacks.add(new ItemStack(sameItem, 1, i));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + stack.func_77960_j();
    }

    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        ICraftingPatternDetails patternDetails = this.getPatternForItem(stack, player.field_70170_p);
        if (!(patternDetails instanceof PatternDetailsMagical)) {
            lines.add(EnumChatFormatting.RED + GuiText.InvalidPattern.getLocal());
            return;
        }
        PatternDetailsMagical details = (PatternDetailsMagical)patternDetails;
        IAEItemStack[] input = details.getCondensedInputs();
        IAEItemStack[] output = details.getCondensedOutputs();
        String label = GuiText.Crafts.getLocal() + ": ";
        String and = ' ' + GuiText.And.getLocal() + ' ';
        String with = GuiText.With.getLocal() + ": ";
        boolean first = true;
        for (IAEItemStack aeStack : output) {
            if (aeStack == null) continue;
            lines.add((first ? label : and) + aeStack.getStackSize() + ' ' + Platform.getItemDisplayName((Object)aeStack));
            first = false;
        }
        if (details.getManaCost() > 0) {
            first = false;
            lines.add(with + details.getManaCost() + ' ' + StatCollector.func_74838_a((String)"mwi.mana.name"));
        } else {
            first = true;
        }
        for (IAEItemStack aeStack : input) {
            if (aeStack == null) continue;
            lines.add((first ? with : and) + aeStack.getStackSize() + ' ' + Platform.getItemDisplayName((Object)aeStack));
            first = false;
        }
    }

    public ICraftingPatternDetails getPatternForItem(ItemStack stack, World world) {
        try {
            if (stack != null) {
                switch (stack.func_77960_j()) {
                    case 0: {
                        return ContentAE2Config.ENABLE_blockMagicalAssemblerApothecary ? new PatternDetailsMagical(PatternDetailsMagical.MagicalPatternType.APOTHECARY, stack, world) : null;
                    }
                    case 1: {
                        return ContentAE2Config.ENABLE_blockMagicalAssemblerRunicAltar ? new PatternDetailsMagical(PatternDetailsMagical.MagicalPatternType.RUNIC_ALTAR, stack, world) : null;
                    }
                    case 2: {
                        return ContentAE2Config.ENABLE_blockMagicalAssemblerManaInfusion ? new PatternDetailsMagical(PatternDetailsMagical.MagicalPatternType.MANA_INFUSION, stack, world) : null;
                    }
                    case 3: {
                        return ContentAE2Config.ENABLE_blockMagicalAssemblerElvenTrade ? new PatternDetailsMagical(PatternDetailsMagical.MagicalPatternType.ELVEN_TRADE, stack, world) : null;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

