/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.ae2.items.patterns;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.localization.GuiText;
import appeng.util.Platform;
import by.fxg.mwicontent.ae2.ContentAE2Config;
import by.fxg.mwicontent.ae2.items.patterns.ItemBasicCraftingPattern;
import by.fxg.mwicontent.ae2.util.PatternDetailsThaumic;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class ItemCraftingPatternThaumic
extends ItemBasicCraftingPattern {
    private static final int SUBTYPES = 2;
    private static final String FROM_ASPECTS = "mwi.fromAspects.name";
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemCraftingPatternThaumic() {
        super("itemCraftingPatternThaumic");
        this.func_77627_a(true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.icons = new IIcon[2];
        for (int i = 0; i != this.icons.length; ++i) {
            this.icons[i] = register.func_94245_a("mwi:ae2/itemCraftingPatternThaumic" + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return damage > -1 && damage < this.icons.length ? this.icons[damage] : this.icons[0];
    }

    protected void getCheckedSubItems(Item sameItem, CreativeTabs creativeTab, List<ItemStack> itemStacks) {
        for (int i = 0; i != 2; ++i) {
            itemStacks.add(new ItemStack(sameItem, 1, i));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + stack.func_77960_j();
    }

    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        ICraftingPatternDetails patternDetails = this.getPatternForItem(stack, player.field_70170_p);
        if (!(patternDetails instanceof PatternDetailsThaumic)) {
            lines.add(EnumChatFormatting.RED + GuiText.InvalidPattern.getLocal());
            return;
        }
        PatternDetailsThaumic details = (PatternDetailsThaumic)patternDetails;
        IAEItemStack[] input = details.getCondensedInputs();
        IAEItemStack[] output = details.getCondensedOutputs();
        String label = GuiText.Crafts.getLocal() + ": ";
        String and = ' ' + GuiText.And.getLocal() + ' ';
        String with = GuiText.With.getLocal() + ": ";
        boolean first = true;
        for (IAEItemStack aeStack : output) {
            if (aeStack == null) continue;
            lines.add((first ? label : and) + aeStack.getStackSize() + ' ' + Platform.getItemDisplayName((Object)aeStack));
            first = false;
        }
        first = true;
        for (IAEItemStack aeStack : input) {
            if (aeStack == null) continue;
            lines.add((first ? with : and) + aeStack.getStackSize() + ' ' + Platform.getItemDisplayName((Object)aeStack));
            first = false;
        }
        AspectList aspects = details.getAspectList();
        if (aspects != null) {
            first = true;
            for (Map.Entry entry : aspects.aspects.entrySet()) {
                if (entry.getValue() == null) continue;
                lines.add((first ? StatCollector.func_74838_a((String)FROM_ASPECTS) : and) + (Integer)entry.getValue() + " " + ((Aspect)entry.getKey()).getName());
                first = false;
            }
        }
    }

    public ICraftingPatternDetails getPatternForItem(ItemStack stack, World world) {
        try {
            if (stack != null && ContentAE2Config.ENABLE_blockThaumicAssembler) {
                switch (stack.func_77960_j()) {
                    case 0: {
                        return new PatternDetailsThaumic(PatternDetailsThaumic.ThaumicPatternType.ALCHEMY, stack, world);
                    }
                    case 1: {
                        return new PatternDetailsThaumic(PatternDetailsThaumic.ThaumicPatternType.INFUSION, stack, world);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

