/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.ae2.tile.assemblers;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.apiext.IAdvancedCraftingProvider;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import by.fxg.basicfml.collections.GDXArray;
import by.fxg.basicfml.inventory.Inventory;
import by.fxg.mwicontent.ae2.tile.TileAEGridTickableInv;
import io.netty.buffer.ByteBuf;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import ru.justagod.cutter.invoke.Invoke;

public abstract class TileAdvMolecularAssembler
extends TileAEGridTickableInv
implements IAdvancedCraftingProvider,
IPowerChannelState {
    protected static final int[] ACCESSIBLE_SIDES = new int[0];
    protected final AppEngInternalInventory inventoryPatterns;
    protected final GDXArray<ICraftingPatternDetails> craftingList;
    protected final GDXArray<IAEItemStack> craftArray;
    protected final MachineSource actionSource;
    protected IInventory craftingResourcesInventory = null;
    protected ICraftingPatternDetails currentPatternDetails = null;
    protected long craftingAmount = 0L;
    protected byte cachedCraftingDetailsIndex = (byte)-1;
    protected boolean isPowered = false;

    public TileAdvMolecularAssembler(int patternInvSlots, int craftArraySlots) {
        this.inventoryPatterns = new AppEngInternalInventory((IAEAppEngInventory)this, patternInvSlots);
        this.craftingList = new GDXArray(true, false, patternInvSlots);
        this.craftArray = new GDXArray(true, false, craftArraySlots);
        this.actionSource = new MachineSource((IActionHost)this);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public TileAdvMolecularAssembler() {
        this(36, 9);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBTAssembler(NBTTagCompound compound) {
        if (this.craftingResourcesInventory != null && this.cachedCraftingDetailsIndex > -1) {
            compound.func_74774_a("mwiccdi", this.cachedCraftingDetailsIndex);
            compound.func_74772_a("mwica", this.craftingAmount);
            compound.func_74777_a("mwicris", (short)this.craftingResourcesInventory.func_70302_i_());
            NBTTagList tagList = new NBTTagList();
            for (int i = 0; i < this.craftingResourcesInventory.func_70302_i_(); ++i) {
                ItemStack stack = this.craftingResourcesInventory.func_70301_a(i);
                if (stack == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74777_a("idx", (short)((byte)i));
                stack.func_77955_b(tag);
                tagList.func_74742_a((NBTBase)tag);
            }
            compound.func_74782_a("mwicri", (NBTBase)tagList);
        }
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBTAssembler(NBTTagCompound compound) {
        if (compound.func_74764_b("mwiccdi") && compound.func_74764_b("mwicri")) {
            this.cachedCraftingDetailsIndex = compound.func_74771_c("mwiccdi");
            this.craftingAmount = compound.func_74763_f("mwica");
            int invSize = compound.func_74765_d("mwicris");
            if (invSize > 0) {
                this.craftingResourcesInventory = new Inventory(invSize);
                NBTTagList tagList = compound.func_150295_c("mwicri", 10);
                for (int i = 0; i < invSize; ++i) {
                    NBTTagCompound tag = tagList.func_150305_b(i);
                    int slot = tag.func_74765_d("idx") & 0xFFFF;
                    if (slot > this.func_70302_i_()) continue;
                    try {
                        this.craftingResourcesInventory.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)tag));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        Invoke.server(() -> {});
        if (this.cachedCraftingDetailsIndex > -1 && this.currentPatternDetails == null && this.cachedCraftingDetailsIndex < this.craftingList.size) {
            this.currentPatternDetails = (ICraftingPatternDetails)this.craftingList.get((int)this.cachedCraftingDetailsIndex);
        }
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStreamAssembler(ByteBuf data) {
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStreamAssembler(ByteBuf data) {
        data.writeBoolean(this.isPowered);
    }

    @MENetworkEventSubscribe
    public void onChannelsChanged(MENetworkChannelsChanged c) {
        try {
            AENetworkProxy proxy = this.getProxy();
            this.checkPowerChanges(proxy);
            proxy.getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, proxy.getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @MENetworkEventSubscribe
    public void onPowerStatusChange(MENetworkPowerStatusChange c) {
        try {
            AENetworkProxy proxy = this.getProxy();
            this.checkPowerChanges(proxy);
            proxy.getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, proxy.getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    protected void checkPowerChanges(AENetworkProxy proxy) throws GridAccessException {
        boolean newState;
        boolean bl = newState = proxy.isActive() && proxy.getEnergy().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
        if (this.isPowered != newState) {
            this.isPowered = newState;
            this.markForUpdate();
        }
    }

    protected boolean isPatternValid(ICraftingPatternDetails details) {
        return details != null && details.isCraftable();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public abstract int getProcessingPower();

    public abstract String getUnlocalizedName();

    public boolean isBusy() {
        return this.currentPatternDetails != null;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public boolean isActive() {
        return this.isPowered;
    }

    public IInventory getInternalInventory() {
        return this.inventoryPatterns;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    public final int[] getAccessibleSlotsBySide(ForgeDirection whichSide) {
        return ACCESSIBLE_SIDES;
    }

    private /* synthetic */ void lambda$provideCrafting$1(ICraftingProviderHelper craftingTracker) {
    }
}

