/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.ae2.tile.assemblers;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import by.fxg.mwicontent.ae2.ContentAE2;
import by.fxg.mwicontent.ae2.ContentAE2Config;
import by.fxg.mwicontent.ae2.tile.assemblers.TileAdvMolecularAssembler;
import by.fxg.mwicontent.ae2.util.PatternDetailsMatter;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public final class TileReplicationAssembler
extends TileAdvMolecularAssembler
implements IFluidHandler {
    private static final String UNLOCALIZED_NAME = "text.blockReplicationAssembler.name";

    public TileReplicationAssembler() {
        super(36, 1);
    }

    @Override
    protected boolean isPatternValid(ICraftingPatternDetails details) {
        return details instanceof PatternDetailsMatter;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack != null && stack.func_77973_b() == ContentAE2.itemCraftingPatternReplication;
    }

    public ItemStack getCrafterIcon() {
        return new ItemStack(ContentAE2.blockReplicationAssembler);
    }

    @Override
    public int getProcessingPower() {
        return ContentAE2Config.REPLICATION_ASSEMBLER_CRAFT_SPEED;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource != null && resource.amount > 0 && resource.getFluid() == BlocksItems.getFluid((InternalName)InternalName.fluidUuMatter)) {
            try {
                AENetworkProxy proxy = this.getProxy();
                IMEMonitor fluidStorage = proxy.getStorage().getFluidInventory();
                IAEFluidStack aeStack = AEApi.instance().storage().createFluidStack(resource);
                IAEFluidStack leftovers = (IAEFluidStack)fluidStorage.injectItems((IAEStack)aeStack, doFill ? Actionable.MODULATE : Actionable.SIMULATE, (BaseActionSource)this.actionSource);
                return leftovers != null ? (int)((long)resource.amount - leftovers.getStackSize()) : resource.amount;
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == BlocksItems.getFluid((InternalName)InternalName.fluidUuMatter);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return ContentAE2Config.REPLICATION_ASSEMBLER_FTI;
    }

    @Override
    public String getUnlocalizedName() {
        return UNLOCALIZED_NAME;
    }
}

