/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.ae2.util;

import appeng.api.AEApi;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.apiext.ICraftingPatternDetailsExtension;
import appeng.container.ContainerNull;
import appeng.util.ItemSorters;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import by.fxg.mwicontent.ae2.util.PatternTestStatus;
import fox.spiteful.avaritia.crafting.ExtremeCraftingManager;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class PatternDetailsExtCrafting
implements ICraftingPatternDetails,
ICraftingPatternDetailsExtension,
Comparable<PatternDetailsExtCrafting> {
    private final ItemStack stack;
    private final IAEItemStack pattern;
    private final IAEItemStack[] inputs;
    private final IAEItemStack[] outputs;
    private final IAEItemStack[] condensedInputs;
    private final IAEItemStack[] condensedOutputs;
    private final ItemStack output;
    private final IRecipe recipe;
    private final boolean canSubstitute;
    private int priority = 0;
    private final InventoryCrafting inventoryCrafting = new InventoryCrafting((Container)new ContainerNull(), 9, 9);
    private final InventoryCrafting inventoryTestFrame = new InventoryCrafting((Container)new ContainerNull(), 9, 9);
    private final Set<TestLookup> failCache = new THashSet();
    private final Set<TestLookup> passCache = new THashSet();

    public PatternDetailsExtCrafting(ItemStack stack, World world) {
        this.stack = stack;
        this.pattern = AEItemStack.create((ItemStack)stack);
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            throw new IllegalArgumentException("No pattern here!");
        }
        this.canSubstitute = tag.func_74767_n("substitute");
        NBTTagList inputList = tag.func_150295_c("in", 10);
        ArrayList<IAEItemStack> input = new ArrayList<IAEItemStack>();
        ArrayList<IAEItemStack> output = new ArrayList<IAEItemStack>();
        ArrayList<AEItemStack> containerOut = new ArrayList<AEItemStack>();
        for (int i = 0; i < inputList.func_74745_c(); ++i) {
            IAEItemStack[] inputStack = ItemStack.func_77949_a((NBTTagCompound)inputList.func_150305_b(i));
            this.inventoryCrafting.func_70299_a(i, (ItemStack)inputStack);
            if (inputStack != null && !inputStack.func_77942_o()) {
                this.markItemAs(i, (ItemStack)inputStack, PatternTestStatus.ACCEPT);
            }
            input.add(AEApi.instance().storage().createItemStack((ItemStack)inputStack));
            if (inputStack != null && inputStack.func_77973_b().hasContainerItem((ItemStack)inputStack)) {
                containerOut.add(AEItemStack.create((ItemStack)inputStack.func_77973_b().getContainerItem((ItemStack)inputStack)));
            }
            this.inventoryTestFrame.func_70299_a(i, (ItemStack)inputStack);
        }
        this.recipe = PatternDetailsExtCrafting.findMatchingRecipe(this.inventoryCrafting, world);
        if (this.recipe == null) {
            throw new IllegalStateException("No pattern here!");
        }
        this.output = this.recipe.func_77572_b(this.inventoryCrafting);
        output.add(AEApi.instance().storage().createItemStack(this.output));
        containerOut.stream().filter(item -> item.getStackSize() > 0L).forEach(output::add);
        this.outputs = output.toArray(new IAEItemStack[output.size()]);
        this.inputs = input.toArray(new IAEItemStack[input.size()]);
        HashMap<IAEItemStack, IAEItemStack> tmpInputs = new HashMap<IAEItemStack, IAEItemStack>();
        for (IAEItemStack inputStack : this.inputs) {
            if (inputStack == null) continue;
            IAEItemStack tmp = (IAEItemStack)tmpInputs.get(inputStack);
            if (tmp == null) {
                tmpInputs.put(inputStack, inputStack.copy());
                continue;
            }
            tmp.add(inputStack);
        }
        HashMap<IAEItemStack, IAEItemStack> tmpOutputs = new HashMap<IAEItemStack, IAEItemStack>();
        for (IAEItemStack outputStack : this.outputs) {
            if (outputStack == null) continue;
            IAEItemStack tmp = (IAEItemStack)tmpOutputs.get(outputStack);
            if (tmp == null) {
                tmpOutputs.put(outputStack, outputStack.copy());
                continue;
            }
            tmp.add(outputStack);
        }
        if (tmpInputs.isEmpty() || tmpOutputs.isEmpty()) {
            throw new IllegalStateException("No pattern here!");
        }
        int offset = 0;
        this.condensedInputs = new IAEItemStack[tmpInputs.size()];
        Iterator iterator = tmpInputs.values().iterator();
        while (iterator.hasNext()) {
            IAEItemStack inputStack;
            this.condensedInputs[offset] = inputStack = (IAEItemStack)iterator.next();
            ++offset;
        }
        offset = 0;
        this.condensedOutputs = new IAEItemStack[tmpOutputs.size()];
        iterator = tmpOutputs.values().iterator();
        while (iterator.hasNext()) {
            IAEItemStack outputStack;
            this.condensedOutputs[offset] = outputStack = (IAEItemStack)iterator.next();
            ++offset;
        }
    }

    public static IRecipe findMatchingRecipe(InventoryCrafting matrix, World world) {
        int j;
        int i = 0;
        ItemStack stackFirst = null;
        ItemStack stackSecond = null;
        for (j = 0; j < matrix.func_70302_i_(); ++j) {
            ItemStack matrixStack = matrix.func_70301_a(j);
            if (matrixStack == null) continue;
            if (i == 0) {
                stackFirst = matrixStack;
            }
            if (i == 1) {
                stackSecond = matrixStack;
            }
            ++i;
        }
        if (i == 2 && stackFirst.func_77973_b() == stackSecond.func_77973_b() && stackFirst.field_77994_a == 1 && stackSecond.field_77994_a == 1 && stackFirst.func_77973_b().isRepairable()) {
            return null;
        }
        for (j = 0; j < ExtremeCraftingManager.getInstance().getRecipeList().size(); ++j) {
            IRecipe iRecipe = (IRecipe)ExtremeCraftingManager.getInstance().getRecipeList().get(j);
            if (!iRecipe.func_77569_a(matrix, world)) continue;
            return iRecipe;
        }
        return null;
    }

    public synchronized boolean isValidItemForSlot(int slotIndex, ItemStack i, World w) {
        PatternTestStatus result = this.getStatus(slotIndex, i);
        switch (result) {
            case ACCEPT: {
                return true;
            }
            case DECLINE: {
                return false;
            }
        }
        for (int j = 0; j < this.inventoryCrafting.func_70302_i_(); ++j) {
            this.inventoryTestFrame.func_70299_a(j, this.inventoryCrafting.func_70301_a(j));
        }
        this.inventoryTestFrame.func_70299_a(slotIndex, i);
        if (this.recipe.func_77569_a(this.inventoryTestFrame, w)) {
            ItemStack testOutput = this.recipe.func_77572_b(this.inventoryTestFrame);
            if (Platform.isSameItemPrecise((ItemStack)this.output, (ItemStack)testOutput)) {
                this.inventoryTestFrame.func_70299_a(slotIndex, this.inventoryCrafting.func_70301_a(slotIndex));
                this.markItemAs(slotIndex, i, PatternTestStatus.ACCEPT);
                return true;
            }
        } else {
            ItemStack testOutput = CraftingManager.func_77594_a().func_82787_a(this.inventoryTestFrame, w);
            if (Platform.isSameItemPrecise((ItemStack)this.output, (ItemStack)testOutput)) {
                this.inventoryTestFrame.func_70299_a(slotIndex, this.inventoryCrafting.func_70301_a(slotIndex));
                this.markItemAs(slotIndex, i, PatternTestStatus.ACCEPT);
                return true;
            }
        }
        this.markItemAs(slotIndex, i, PatternTestStatus.DECLINE);
        return false;
    }

    private void markItemAs(int slotIndex, ItemStack i, PatternTestStatus testStatus) {
        if (testStatus == PatternTestStatus.TEST || i.func_77942_o()) {
            return;
        }
        (testStatus == PatternTestStatus.ACCEPT ? this.passCache : this.failCache).add(new TestLookup(slotIndex, i));
    }

    private PatternTestStatus getStatus(int slotIndex, ItemStack i) {
        if (this.inventoryCrafting.func_70301_a(slotIndex) == null) {
            return i == null ? PatternTestStatus.ACCEPT : PatternTestStatus.DECLINE;
        }
        if (i == null) {
            return PatternTestStatus.DECLINE;
        }
        if (i.func_77942_o()) {
            return PatternTestStatus.TEST;
        }
        if (this.passCache.contains(new TestLookup(slotIndex, i))) {
            return PatternTestStatus.ACCEPT;
        }
        if (this.failCache.contains(new TestLookup(slotIndex, i))) {
            return PatternTestStatus.DECLINE;
        }
        return PatternTestStatus.TEST;
    }

    public ItemStack getOutput(InventoryCrafting craftingInv, World w) {
        for (int i = 0; i < craftingInv.func_70302_i_(); ++i) {
            if (this.isValidItemForSlot(i, craftingInv.func_70301_a(i), w)) continue;
            return null;
        }
        if (this.outputs != null && this.outputs.length > 0) {
            return this.outputs[0].getItemStack();
        }
        return null;
    }

    public ItemStack getPattern() {
        return this.stack;
    }

    public boolean isCraftable() {
        return false;
    }

    public boolean canSubstitute() {
        return this.canSubstitute;
    }

    public IAEItemStack[] getInputs() {
        return this.inputs;
    }

    public IAEItemStack[] getOutputs() {
        return this.outputs;
    }

    public IAEItemStack[] getCondensedInputs() {
        return this.condensedInputs;
    }

    public IAEItemStack[] getCondensedOutputs() {
        return this.condensedOutputs;
    }

    public int getCraftingMatrixHeight() {
        return 9;
    }

    public int getCraftingMatrixWidth() {
        return 9;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int compareTo(PatternDetailsExtCrafting o) {
        return ItemSorters.compareInt((int)o.priority, (int)this.priority);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatternDetailsExtCrafting other = (PatternDetailsExtCrafting)obj;
        if (this.pattern != null && other.pattern != null) {
            return this.pattern.equals(other.pattern);
        }
        return false;
    }

    private static final class TestLookup {
        private final int slot;
        private final int ref;
        private final int hash;

        public TestLookup(int slot, ItemStack i) {
            this(slot, i.func_77973_b(), i.func_77960_j());
        }

        public TestLookup(int slot, Item item, int dmg) {
            this.slot = slot;
            this.ref = dmg << 16 | Item.func_150891_b((Item)item) & 0xFFFF;
            int offset = 3 * slot;
            this.hash = this.ref << offset | this.ref >> offset + 32;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            boolean equality;
            if (obj instanceof TestLookup) {
                TestLookup b = (TestLookup)obj;
                equality = b.slot == this.slot && b.ref == this.ref;
            } else {
                equality = false;
            }
            return equality;
        }
    }
}

