/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.ae2.util;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEItemStack;
import appeng.apiext.ICraftingPatternDetailsExtension;
import by.fxg.basicfml.collections.GDXArray;
import by.fxg.basicfml.inventory.Inventory;
import by.fxg.mwicontent.ae2.util.InventoryArrayList;
import by.fxg.mwicontent.ae2.util.PatternDetailsDummy;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeElvenTrade;
import vazkii.botania.api.recipe.RecipeManaInfusion;
import vazkii.botania.api.recipe.RecipePetals;
import vazkii.botania.api.recipe.RecipeRuneAltar;

public class PatternDetailsMagical
extends PatternDetailsDummy
implements ICraftingPatternDetailsExtension {
    private static final Pair<ItemStack, Integer> EMPTY_PAIR = Pair.of(null, (Object)0);
    private final MagicalPatternType patternType;
    private final boolean isManaAlchemyInfusion;
    private final ItemStack stack;
    private int manaCost;
    private final Object recipe;
    private final IAEItemStack[] inputs;
    private final IAEItemStack[] outputs;
    private final IAEItemStack[] condensedInputs;
    private final IAEItemStack[] condensedOutputs;

    public PatternDetailsMagical(MagicalPatternType patternType, ItemStack stack, World world) {
        this.patternType = patternType;
        this.stack = stack;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            throw new IllegalArgumentException("ItemStack doesn't have a nbt tag");
        }
        this.isManaAlchemyInfusion = tag.func_74767_n("ismai");
        NBTTagList inputList = tag.func_150295_c("in", 10);
        Inventory invCrafting = new Inventory(16);
        GDXArray inputsArray = new GDXArray(false, true, 16);
        for (int i = 0; i < inputList.func_74745_c(); ++i) {
            ItemStack stackInput = ItemStack.func_77949_a((NBTTagCompound)inputList.func_150305_b(i));
            invCrafting.func_70299_a(i, stackInput);
            inputsArray.add((Object)AEApi.instance().storage().createItemStack(stackInput));
        }
        if (inputsArray.isEmpty()) {
            throw new IllegalStateException("No inputs has been found");
        }
        this.recipe = PatternDetailsMagical.getRecipe(patternType, this.isManaAlchemyInfusion, (IInventory)invCrafting);
        Pair<ItemStack, Integer> outputPair = PatternDetailsMagical.getMatchedData(patternType, this.isManaAlchemyInfusion, this.recipe);
        if (outputPair.getKey() == null) {
            throw new IllegalStateException("No recipe has been found");
        }
        this.inputs = (IAEItemStack[])inputsArray.toArray(IAEItemStack.class);
        inputsArray.size = 0;
        for (int i = 0; i < this.inputs.length; ++i) {
            IAEItemStack aeStack = this.inputs[i];
            if (aeStack == null) continue;
            inputsArray.add((Object)aeStack);
        }
        this.condensedInputs = (IAEItemStack[])inputsArray.toArray(IAEItemStack.class);
        IAEItemStack output = AEApi.instance().storage().createItemStack((ItemStack)outputPair.getKey());
        this.outputs = new IAEItemStack[]{output};
        this.condensedOutputs = this.outputs;
    }

    public int getManaCost() {
        Pair<ItemStack, Integer> outputPair = PatternDetailsMagical.getMatchedData(this.patternType, this.isManaAlchemyInfusion, this.recipe);
        this.manaCost = Math.max(0, (Integer)outputPair.getValue());
        return this.manaCost;
    }

    @Override
    public ItemStack getPattern() {
        return this.stack;
    }

    public IAEItemStack[] getInputs() {
        return this.inputs;
    }

    public IAEItemStack[] getOutputs() {
        return this.outputs;
    }

    public IAEItemStack[] getCondensedInputs() {
        return this.condensedInputs;
    }

    public IAEItemStack[] getCondensedOutputs() {
        return this.condensedOutputs;
    }

    public int getCraftingMatrixHeight() {
        return 4;
    }

    public int getCraftingMatrixWidth() {
        return 4;
    }

    @Override
    public boolean isValidItemForSlot(int slotIndex, ItemStack itemStack, World world) {
        return false;
    }

    public ItemStack getOutput(InventoryCrafting craftingInv, World world) {
        return null;
    }

    public MagicalPatternType getPatternType() {
        return this.patternType;
    }

    public boolean isManaAlchemyInfusion() {
        return this.isManaAlchemyInfusion;
    }

    public static ItemStack getMatchedOutput(MagicalPatternType patternType, boolean isManaAlchemyInfusion, IInventory invCrafting) {
        return (ItemStack)PatternDetailsMagical.getMatchedData(patternType, isManaAlchemyInfusion, invCrafting).getKey();
    }

    public static Pair<ItemStack, Integer> getMatchedData(MagicalPatternType patternType, boolean isManaAlchemyInfusion, IInventory invCrafting) {
        if (patternType == null || invCrafting == null) {
            return EMPTY_PAIR;
        }
        InventoryArrayList ingredients = new InventoryArrayList();
        for (int i = 0; i < invCrafting.func_70302_i_(); ++i) {
            ItemStack stack = invCrafting.func_70301_a(i);
            if (stack == null) continue;
            ingredients.stacks.add(stack);
        }
        switch (patternType) {
            case APOTHECARY: {
                for (Object recipe : BotaniaAPI.petalRecipes) {
                    if (recipe.getInputs().size() != ingredients.func_70302_i_() || !recipe.matches((IInventory)ingredients)) continue;
                    return Pair.of((Object)recipe.getOutput(), (Object)0);
                }
                break;
            }
            case RUNIC_ALTAR: {
                for (Object recipe : BotaniaAPI.runeAltarRecipes) {
                    if (recipe.getInputs().size() != ingredients.func_70302_i_() || !recipe.matches((IInventory)ingredients)) continue;
                    return Pair.of((Object)recipe.getOutput(), (Object)recipe.getManaUsage());
                }
                break;
            }
            case MANA_INFUSION: {
                ItemStack stackInput;
                ItemStack itemStack = stackInput = ingredients.func_70302_i_() == 1 ? ingredients.func_70301_a(0) : null;
                if (stackInput == null) {
                    return EMPTY_PAIR;
                }
                for (RecipeManaInfusion recipe : BotaniaAPI.manaInfusionRecipes) {
                    if (recipe.isConjuration() || recipe.isAlchemy() != isManaAlchemyInfusion || !recipe.matches(stackInput)) continue;
                    return Pair.of((Object)recipe.getOutput(), (Object)recipe.getManaToConsume());
                }
                break;
            }
            case ELVEN_TRADE: {
                for (Object recipe : BotaniaAPI.elvenTradeRecipes) {
                    if (recipe.getInputs().size() != ingredients.func_70302_i_() || !recipe.matches(ingredients.stacks, false)) continue;
                    return Pair.of((Object)recipe.getOutput(), (Object)0);
                }
                break;
            }
        }
        return EMPTY_PAIR;
    }

    public static Object getRecipe(MagicalPatternType patternType, boolean isManaAlchemyInfusion, IInventory invCrafting) {
        if (patternType == null || invCrafting == null) {
            return null;
        }
        InventoryArrayList ingredients = new InventoryArrayList();
        for (int i = 0; i < invCrafting.func_70302_i_(); ++i) {
            ItemStack stack = invCrafting.func_70301_a(i);
            if (stack == null) continue;
            ingredients.stacks.add(stack);
        }
        switch (patternType) {
            case APOTHECARY: {
                for (Object recipe : BotaniaAPI.petalRecipes) {
                    if (recipe.getInputs().size() != ingredients.func_70302_i_() || !recipe.matches((IInventory)ingredients)) continue;
                    return recipe;
                }
                break;
            }
            case RUNIC_ALTAR: {
                for (Object recipe : BotaniaAPI.runeAltarRecipes) {
                    if (recipe.getInputs().size() != ingredients.func_70302_i_() || !recipe.matches((IInventory)ingredients)) continue;
                    return recipe;
                }
                break;
            }
            case MANA_INFUSION: {
                ItemStack stackInput;
                ItemStack itemStack = stackInput = ingredients.func_70302_i_() == 1 ? ingredients.func_70301_a(0) : null;
                if (stackInput == null) {
                    return null;
                }
                for (RecipeManaInfusion recipe : BotaniaAPI.manaInfusionRecipes) {
                    if (recipe.isConjuration() || recipe.isAlchemy() != isManaAlchemyInfusion || !recipe.matches(stackInput)) continue;
                    return recipe;
                }
                break;
            }
            case ELVEN_TRADE: {
                for (Object recipe : BotaniaAPI.elvenTradeRecipes) {
                    if (recipe.getInputs().size() != ingredients.func_70302_i_() || !recipe.matches(ingredients.stacks, false)) continue;
                    return recipe;
                }
                break;
            }
        }
        return null;
    }

    public static Pair<ItemStack, Integer> getMatchedData(MagicalPatternType patternType, boolean isManaAlchemyInfusion, Object recipe) {
        if (patternType == null || recipe == null) {
            return EMPTY_PAIR;
        }
        switch (patternType) {
            case APOTHECARY: {
                if (!(recipe instanceof RecipePetals)) break;
                RecipePetals petalRecipe = (RecipePetals)recipe;
                return Pair.of((Object)petalRecipe.getOutput(), (Object)0);
            }
            case RUNIC_ALTAR: {
                if (!(recipe instanceof RecipeRuneAltar)) break;
                RecipeRuneAltar runeAltarRecipe = (RecipeRuneAltar)recipe;
                return Pair.of((Object)runeAltarRecipe.getOutput(), (Object)runeAltarRecipe.getManaUsage());
            }
            case MANA_INFUSION: {
                if (!(recipe instanceof RecipeManaInfusion)) break;
                RecipeManaInfusion manaInfusionRecipe = (RecipeManaInfusion)recipe;
                return Pair.of((Object)manaInfusionRecipe.getOutput(), (Object)manaInfusionRecipe.getManaToConsume());
            }
            case ELVEN_TRADE: {
                if (!(recipe instanceof RecipeElvenTrade)) break;
                RecipeElvenTrade elvenTradeRecipe = (RecipeElvenTrade)recipe;
                return Pair.of((Object)elvenTradeRecipe.getOutput(), (Object)0);
            }
        }
        return EMPTY_PAIR;
    }

    public int hashCode() {
        return this.recipe.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof PatternDetailsMagical) {
            return this.recipe == ((PatternDetailsMagical)other).recipe;
        }
        return false;
    }

    public static enum MagicalPatternType {
        APOTHECARY,
        RUNIC_ALTAR,
        MANA_INFUSION,
        ELVEN_TRADE;

        private static final MagicalPatternType[] values;

        public static MagicalPatternType fromOrdinal(int ordinal) {
            return values[Math.max(0, ordinal > values.length - 1 ? 0 : ordinal)];
        }

        static {
            values = MagicalPatternType.values();
        }
    }
}

