/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.ae2.util;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEItemStack;
import by.fxg.mwicontent.ae2.util.PatternDetailsDummy;
import ic2.core.uu.UuIndex;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class PatternDetailsMatter
extends PatternDetailsDummy {
    private final ItemStack stack;
    private final ItemStack recipe;
    private final double matterCost;
    private final IAEItemStack inputStack;
    private final IAEItemStack outputStack;
    private final IAEItemStack[] input;
    private final IAEItemStack[] output;

    public PatternDetailsMatter(ItemStack stack, World world) {
        this.stack = stack;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            throw new IllegalArgumentException("ItemStack doesn't have a nbt tag");
        }
        ItemStack recipeStack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("rS"));
        if (recipeStack == null) {
            throw new IllegalArgumentException("Recipe Stack doesn't exist");
        }
        recipeStack.field_77994_a = 1;
        this.recipe = recipeStack;
        double matterCost = UuIndex.instance.getInBuckets(recipeStack);
        if (matterCost < 0.0 || matterCost == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("Recipe Stack can't be replicated!");
        }
        this.matterCost = matterCost;
        this.inputStack = AEApi.instance().storage().createItemStack(new ItemStack(Blocks.field_150347_e));
        this.outputStack = AEApi.instance().storage().createItemStack(recipeStack);
        this.input = new IAEItemStack[]{this.inputStack};
        this.output = new IAEItemStack[]{this.outputStack};
    }

    @Override
    public ItemStack getPattern() {
        return this.stack;
    }

    public IAEItemStack[] getInputs() {
        return this.input;
    }

    public IAEItemStack[] getOutputs() {
        return this.output;
    }

    public IAEItemStack[] getCondensedInputs() {
        return this.input;
    }

    public IAEItemStack[] getCondensedOutputs() {
        return this.output;
    }

    public IAEItemStack getSingleInput() {
        return this.inputStack;
    }

    public IAEItemStack getSingleOutput() {
        return this.outputStack;
    }

    public double getMatterCost() {
        return this.matterCost;
    }

    public ItemStack getOutput(InventoryCrafting craftingInv, World world) {
        return null;
    }

    public int hashCode() {
        return this.recipe.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof PatternDetailsMatter) {
            return this.recipe == ((PatternDetailsMatter)other).recipe;
        }
        return false;
    }
}

