/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.ae2.util;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEItemStack;
import appeng.apiext.ICraftingPatternDetailsExtension;
import by.fxg.basicfml.collections.GDXArray;
import by.fxg.basicfml.inventory.Inventory;
import by.fxg.mwicontent.ae2.util.InventoryArrayList;
import by.fxg.mwicontent.ae2.util.PatternDetailsDummy;
import java.util.ArrayList;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.InfusionRecipe;

public class PatternDetailsThaumic
extends PatternDetailsDummy
implements ICraftingPatternDetailsExtension {
    private final ThaumicPatternType patternType;
    private final ItemStack stack;
    private final AspectList aspectList;
    private final Aspect[] aspectTypes;
    private final Object recipe;
    private final IAEItemStack[] inputs;
    private final IAEItemStack[] outputs;
    private final IAEItemStack[] condensedInputs;
    private final IAEItemStack[] condensedOutputs;

    public PatternDetailsThaumic(ThaumicPatternType patternType, ItemStack stack, World world) {
        this.patternType = patternType;
        this.stack = stack;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            throw new IllegalArgumentException("ItemStack doesn't have a nbt tag");
        }
        NBTTagList inputList = tag.func_150295_c("in", 10);
        Inventory invCrafting = new Inventory(24);
        GDXArray inputsArray = new GDXArray(false, true, 24);
        for (int i = 0; i < inputList.func_74745_c(); ++i) {
            ItemStack stackInput = ItemStack.func_77949_a((NBTTagCompound)inputList.func_150305_b(i));
            invCrafting.func_70299_a(i, stackInput);
            inputsArray.add((Object)AEApi.instance().storage().createItemStack(stackInput));
        }
        if (inputsArray.isEmpty()) {
            throw new IllegalStateException("No inputs has been found");
        }
        if (patternType == ThaumicPatternType.ALCHEMY) {
            CrucibleRecipe recipe = (CrucibleRecipe)PatternDetailsThaumic.getRecipeFor(ThaumicPatternType.ALCHEMY, (IInventory)invCrafting);
            if (recipe == null || recipe.getRecipeOutput() == null) {
                throw new IllegalStateException("No recipe has been found");
            }
            if (recipe.catalyst != null && PatternDetailsThaumic.getCrucibleCatalystStack(recipe.catalyst) == null) {
                throw new IllegalStateException("Invalid catalyst");
            }
            IAEItemStack[] input = this.fixItemDamage(recipe.catalyst == null ? new ItemStack(Blocks.field_150347_e, 1, 0) : PatternDetailsThaumic.getCrucibleCatalystStack(recipe.catalyst));
            IAEItemStack aeInput = AEApi.instance().storage().createItemStack((ItemStack)input);
            this.inputs = new IAEItemStack[]{aeInput};
            this.condensedInputs = this.inputs;
            IAEItemStack output = AEApi.instance().storage().createItemStack(this.fixItemDamage(recipe.getRecipeOutput()));
            this.outputs = new IAEItemStack[]{output};
            this.condensedOutputs = this.outputs;
            this.aspectList = recipe.aspects;
            this.recipe = recipe;
        } else {
            InfusionRecipe recipe = (InfusionRecipe)PatternDetailsThaumic.getRecipeFor(ThaumicPatternType.INFUSION, (IInventory)invCrafting);
            if (recipe == null || !(recipe.getRecipeOutput() instanceof ItemStack)) {
                throw new IllegalStateException("No recipe has been found");
            }
            if (recipe.getRecipeInput() == null) {
                throw new IllegalStateException("Input ingredient hasn't been found");
            }
            this.inputs = (IAEItemStack[])inputsArray.toArray(IAEItemStack.class);
            inputsArray.size = 0;
            for (IAEItemStack aeStack : this.inputs) {
                if (aeStack == null) continue;
                inputsArray.add((Object)aeStack);
            }
            this.condensedInputs = (IAEItemStack[])inputsArray.toArray(IAEItemStack.class);
            IAEItemStack output = AEApi.instance().storage().createItemStack(this.fixItemDamage((ItemStack)recipe.getRecipeOutput()));
            this.outputs = new IAEItemStack[]{output};
            this.condensedOutputs = this.outputs;
            this.aspectList = recipe.aspects;
            this.recipe = recipe;
        }
        this.aspectTypes = this.aspectList == null ? new Aspect[]{} : this.aspectList.getAspectsSorted();
    }

    @Override
    public ItemStack getPattern() {
        return this.stack;
    }

    public IAEItemStack[] getInputs() {
        return this.inputs;
    }

    public IAEItemStack[] getOutputs() {
        return this.outputs;
    }

    public IAEItemStack[] getCondensedInputs() {
        return this.condensedInputs;
    }

    public IAEItemStack[] getCondensedOutputs() {
        return this.condensedOutputs;
    }

    public int getCraftingMatrixHeight() {
        return 8;
    }

    public int getCraftingMatrixWidth() {
        return 3;
    }

    @Override
    public boolean isValidItemForSlot(int slotIndex, ItemStack itemStack, World world) {
        return false;
    }

    public ItemStack getOutput(InventoryCrafting craftingInv, World world) {
        return null;
    }

    public ThaumicPatternType getPatternType() {
        return this.patternType;
    }

    public AspectList getAspectList() {
        return this.aspectList;
    }

    public Aspect[] getAspectTypes() {
        return this.aspectTypes;
    }

    public Object getRecipe() {
        return this.recipe;
    }

    public static <T> T getRecipeFor(ThaumicPatternType patternType, IInventory invCrafting) {
        if (patternType == null || invCrafting == null) {
            return null;
        }
        InventoryArrayList ingredients = new InventoryArrayList();
        for (int i = 0; i < invCrafting.func_70302_i_(); ++i) {
            ItemStack stack = invCrafting.func_70301_a(i);
            if (stack == null) continue;
            ingredients.stacks.add(stack);
        }
        switch (patternType) {
            case ALCHEMY: {
                ItemStack stackOutput;
                ItemStack itemStack = stackOutput = ingredients.func_70302_i_() == 1 ? ingredients.func_70301_a(0) : null;
                if (stackOutput == null) {
                    return null;
                }
                for (Object object : ThaumcraftApi.getCraftingRecipes()) {
                    if (!(object instanceof CrucibleRecipe)) continue;
                    CrucibleRecipe recipe = (CrucibleRecipe)object;
                    if (recipe.catalyst != null && PatternDetailsThaumic.getCrucibleCatalystStack(recipe.catalyst) == null || !InfusionRecipe.areItemStacksEqual((ItemStack)recipe.recipeOutput, (ItemStack)stackOutput, (boolean)false)) continue;
                    return (T)recipe;
                }
                break;
            }
            case INFUSION: {
                for (Object object : ThaumcraftApi.getCraftingRecipes()) {
                    InfusionRecipe recipe;
                    if (!(object instanceof InfusionRecipe) || (recipe = PatternDetailsThaumic.passInfusionRecipe((InfusionRecipe)object, ingredients)) == null) continue;
                    return (T)recipe;
                }
                break;
            }
        }
        return null;
    }

    private static ItemStack getCrucibleCatalystStack(Object catalyst) {
        if (catalyst instanceof ItemStack) {
            return (ItemStack)catalyst;
        }
        if (catalyst instanceof ArrayList) {
            ArrayList collection = (ArrayList)catalyst;
            if (collection.isEmpty()) {
                return null;
            }
            Object first = collection.get(0);
            if (first instanceof ItemStack) {
                return (ItemStack)first;
            }
        }
        return null;
    }

    public static ItemStack getMatchedOutput(ThaumicPatternType type, IInventory invCrafting) {
        Object recipeObj = PatternDetailsThaumic.getRecipeFor(type, invCrafting);
        if (recipeObj == null) {
            return null;
        }
        switch (type) {
            case ALCHEMY: {
                return ((CrucibleRecipe)recipeObj).getRecipeOutput();
            }
            case INFUSION: {
                InfusionRecipe recipe = (InfusionRecipe)recipeObj;
                if (!(recipe.getRecipeOutput() instanceof ItemStack)) break;
                return (ItemStack)recipe.getRecipeOutput();
            }
        }
        return null;
    }

    private static InfusionRecipe passInfusionRecipe(InfusionRecipe recipe, InventoryArrayList ingredients) {
        if (recipe.getRecipeOutput() instanceof ItemStack) {
            ItemStack ingredientInput = null;
            for (int i = 0; i < ingredients.func_70302_i_(); ++i) {
                if (!InfusionRecipe.areItemStacksEqual((ItemStack)ingredients.func_70301_a(i), (ItemStack)recipe.recipeInput, (boolean)true)) continue;
                ingredientInput = ingredients.func_70301_a(i);
                break;
            }
            if (ingredientInput == null) {
                return null;
            }
            ItemStack[] componentsArray = new ItemStack[recipe.components.length];
            System.arraycopy(recipe.components, 0, componentsArray, 0, componentsArray.length);
            for (int i = 0; i < ingredients.func_70302_i_(); ++i) {
                ItemStack ingredient = ingredients.func_70301_a(i);
                if (ingredient == ingredientInput) continue;
                boolean taken = false;
                for (int j = 0; j < componentsArray.length; ++j) {
                    ItemStack component = componentsArray[j];
                    if (component == null || !InfusionRecipe.areItemStacksEqual((ItemStack)ingredient, (ItemStack)component, (boolean)true)) continue;
                    taken = true;
                    componentsArray[j] = null;
                    break;
                }
                if (taken) continue;
                return null;
            }
            for (ItemStack itemStack : componentsArray) {
                if (itemStack == null) continue;
                return null;
            }
            return recipe;
        }
        return null;
    }

    private ItemStack fixItemDamage(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.func_77960_j() == Short.MAX_VALUE) {
            stack.func_77964_b(0);
        }
        return stack;
    }

    public int hashCode() {
        return this.recipe != null ? Integer.valueOf(this.recipe.hashCode()) : null;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof PatternDetailsThaumic) {
            return this.recipe == ((PatternDetailsThaumic)other).recipe;
        }
        return false;
    }

    public static enum ThaumicPatternType {
        ALCHEMY,
        INFUSION;

        private static final ThaumicPatternType[] values;

        public static ThaumicPatternType fromOrdinal(int ordinal) {
            return values[Math.max(0, ordinal > values.length - 1 ? 0 : ordinal)];
        }

        static {
            values = ThaumicPatternType.values();
        }
    }
}

