/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.botania;

import by.fxg.basicfml.util.IProxy;
import by.fxg.mwicontent.botania.ContentBotania;
import by.fxg.mwicontent.botania.ContentBotaniaConfig;
import by.fxg.mwicontent.botania.render.RenderBlockManaPool;
import by.fxg.mwicontent.botania.render.RenderBlockManaSpreader;
import by.fxg.mwicontent.botania.tile.TileAlchemyCatalystTable;
import by.fxg.mwicontent.botania.tile.TileInfusionCatalystTable;
import by.fxg.mwicontent.botania.tile.TileWitcheryCatalystTable;
import by.fxg.mwicontent.botania.tile.flowers.FlowerTileAsgardDandelion;
import by.fxg.mwicontent.botania.tile.flowers.FlowerTileCeliaFlos;
import by.fxg.mwicontent.botania.tile.flowers.FlowerTileFeistyPoisonIvy;
import by.fxg.mwicontent.botania.tile.flowers.FlowerTileFlowey;
import by.fxg.mwicontent.botania.tile.flowers.FlowerTileHelheimWeed;
import by.fxg.mwicontent.botania.tile.flowers.FlowerTileMidgardSunflower;
import by.fxg.mwicontent.botania.tile.multi.TileMultiFlower;
import by.fxg.mwicontent.botania.tile.pools.TileAsgardManaPool;
import by.fxg.mwicontent.botania.tile.pools.TileHelheimManaPool;
import by.fxg.mwicontent.botania.tile.pools.TileMidgardManaPool;
import by.fxg.mwicontent.botania.tile.spreaders.TileAsgardManaSpreader;
import by.fxg.mwicontent.botania.tile.spreaders.TileHelheimManaSpreader;
import by.fxg.mwicontent.botania.tile.spreaders.TileMidgardManaSpreader;
import by.fxg.mwintegration.client.render.BasicRenderModel;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import vazkii.botania.api.BotaniaAPI;

public class ContentBotaniaProxyClient
implements IProxy {
    public void onPostInitialization(FMLPostInitializationEvent event) {
        if (!ContentBotaniaConfig.ENABLED) {
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.registerManaPool(ContentBotaniaConfig.ENABLE_blockMidgardManaPool, ContentBotania.blockMidgardManaPool, TileMidgardManaPool.class, "blockMidgardManaPool");
        this.registerManaPool(ContentBotaniaConfig.ENABLE_blockHelheimManaPool, ContentBotania.blockHelheimManaPool, TileHelheimManaPool.class, "blockHelheimManaPool");
        this.registerManaPool(ContentBotaniaConfig.ENABLE_blockAsgardManaPool, ContentBotania.blockAsgardManaPool, TileAsgardManaPool.class, "blockAsgardManaPool");
        this.registerManaSpreader(ContentBotaniaConfig.ENABLE_blockMidgardManaSpreader, ContentBotania.blockMidgardManaSpreader, TileMidgardManaSpreader.class, "blockMidgardManaSpreader");
        this.registerManaSpreader(ContentBotaniaConfig.ENABLE_blockHelheimManaSpreader, ContentBotania.blockHelheimManaSpreader, TileHelheimManaSpreader.class, "blockHelheimManaSpreader");
        this.registerManaSpreader(ContentBotaniaConfig.ENABLE_blockAsgardManaSpreader, ContentBotania.blockAsgardManaSpreader, TileAsgardManaSpreader.class, "blockAsgardManaSpreader");
        this.registerCatalystTables();
        this.registerMultiFlower();
    }

    private void registerManaPool(boolean isEnabled, Block block, Class<? extends TileEntity> tileClass, String textureName) {
        if (isEnabled) {
            RenderBlockManaPool render = new RenderBlockManaPool("botania", textureName);
            MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)block), (IItemRenderer)render);
            ClientRegistry.bindTileEntitySpecialRenderer(tileClass, (TileEntitySpecialRenderer)render);
        }
    }

    private void registerManaSpreader(boolean isEnabled, Block block, Class<? extends TileEntity> tileClass, String textureName) {
        if (isEnabled && block != null) {
            RenderBlockManaSpreader render = new RenderBlockManaSpreader("botania", textureName);
            ClientRegistry.bindTileEntitySpecialRenderer(tileClass, (TileEntitySpecialRenderer)render);
            MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)block), (IItemRenderer)render);
        }
    }

    private void registerCatalystTables() {
        ContentBotaniaProxyClient.regModel(ContentBotania.blockInfusionCatalystTable, TileInfusionCatalystTable.class, "blockInfusionCatalystTable");
        ContentBotaniaProxyClient.regModel(ContentBotania.blockAlchemyCatalystTable, TileAlchemyCatalystTable.class, "blockAlchemyCatalystTable");
        ContentBotaniaProxyClient.regModel(ContentBotania.blockWitcheryCatalystTable, TileWitcheryCatalystTable.class, "blockWitcheryCatalystTable");
    }

    private void registerMultiFlower() {
        ContentBotaniaProxyClient.regModel(ContentBotania.blockMultiFlower, TileMultiFlower.class, "blockMultiFlower");
    }

    @SubscribeEvent
    public void onTextureStitchPost(TextureStitchEvent.Post event) {
        FlowerTileFlowey.cachedIcon = BotaniaAPI.getSignatureForName((String)"flowey").getIconForStack(null);
        FlowerTileMidgardSunflower.cachedIcon = BotaniaAPI.getSignatureForName((String)"midgardSunflower").getIconForStack(null);
        FlowerTileHelheimWeed.cachedIcon = BotaniaAPI.getSignatureForName((String)"helheimWeed").getIconForStack(null);
        FlowerTileAsgardDandelion.cachedIcon = BotaniaAPI.getSignatureForName((String)"asgardDandelion").getIconForStack(null);
        FlowerTileFeistyPoisonIvy.cachedIcon = BotaniaAPI.getSignatureForName((String)"feistyPoisonIvy").getIconForStack(null);
        FlowerTileCeliaFlos.cachedIcon = BotaniaAPI.getSignatureForName((String)"celiaFlos").getIconForStack(null);
    }

    private static void regModel(Block block, Class<? extends TileEntity> tile, String name) {
        if (block == null) {
            return;
        }
        BasicRenderModel render = new BasicRenderModel("botania", name);
        ClientRegistry.bindTileEntitySpecialRenderer(tile, (TileEntitySpecialRenderer)render);
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)block), (IItemRenderer)render);
    }
}

