/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.botania.render;

import by.fxg.mwicontent.botania.tile.pools.TileManaPool;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;
import vazkii.botania.client.core.handler.MultiblockRenderHandler;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.common.block.mana.BlockPool;

@SideOnly(value=Side.CLIENT)
public class RenderBlockManaPool
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private final ResourceLocation texture;
    private final IModelCustom model;
    private Integer renderId = null;

    public RenderBlockManaPool(String branch, String name) {
        this(new ResourceLocation("mwi", "textures/models/" + branch + "/" + name + ".png"), new ResourceLocation("mwi", "models/" + branch + "/" + name + ".obj"));
    }

    public RenderBlockManaPool(ResourceLocation texture, ResourceLocation model) {
        this.texture = texture;
        this.model = AdvancedModelLoader.loadModel((ResourceLocation)model);
        this.createList();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        switch (type) {
            case ENTITY: 
            case INVENTORY: {
                GL11.glTranslatef((float)0.0f, (float)0.2f, (float)0.0f);
                break;
            }
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                GL11.glTranslatef((float)0.5f, (float)1.0f, (float)0.5f);
                break;
            }
        }
        this.func_147499_a(this.texture);
        this.renderModel();
        GL11.glPopMatrix();
    }

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float partialTicks) {
        TileManaPool tile = (TileManaPool)tileEntity;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        this.func_147499_a(this.texture);
        this.renderModel();
        float manaLevel = (float)tile.getCurrentMana() / (float)(tile.getAvailableSpaceForMana() + tile.getCurrentMana());
        if (manaLevel > 0.0f) {
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)772, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(MultiblockRenderHandler.rendering ? 0.6f : 1.0f));
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)(0.45f - 0.42f * manaLevel), (float)0.0f);
            GL11.glDisable((int)3008);
            ShaderHelper.useShader((int)ShaderHelper.manaPool);
            this.renderIcon(BlockPool.manaIcon);
            ShaderHelper.releaseShader();
            GL11.glEnable((int)3008);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private void renderIcon(IIcon icon) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78380_c(240);
        tessellator.func_78374_a(-0.5, 0.0, 0.5, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tessellator.func_78374_a(-0.5, 0.0, -0.5, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        tessellator.func_78374_a(0.5, 0.0, -0.5, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a(0.5, 0.0, 0.5, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tessellator.func_78381_a();
    }

    private void createList() {
        this.renderId = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)this.renderId, (int)4864);
        this.model.renderAll();
        GL11.glEndList();
    }

    private void renderModel() {
        this.func_147499_a(this.texture);
        GL11.glCallList((int)this.renderId);
    }
}

