/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.botania.tile.multi;

import by.fxg.mwicontent.botania.tile.multi.SubTileBehaviourOverride;
import by.fxg.mwicontent.botania.tile.multi.TileMultiFlower;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import vazkii.botania.api.subtile.SubTileEntity;

public class EitherCustomOrNormalSubTile {
    public final String type;
    private final SubTileEntity subtile;
    private final SubTileBehaviourOverride customSubtile;

    private EitherCustomOrNormalSubTile(String type, SubTileEntity subtile, SubTileBehaviourOverride customSubtile) {
        this.type = type;
        this.subtile = subtile;
        this.customSubtile = customSubtile;
        if (subtile == null && customSubtile == null) {
            throw new IllegalArgumentException("Can not be neither.");
        }
    }

    public EitherCustomOrNormalSubTile(String type, SubTileEntity tile) {
        this(type, tile, null);
    }

    public EitherCustomOrNormalSubTile(String type, SubTileBehaviourOverride customSubtile) {
        this(type, null, customSubtile);
    }

    public void writeToPacketNBT(NBTTagCompound cmp) {
        if (this.subtile != null) {
            this.subtile.writeToPacketNBT(cmp);
        } else {
            this.customSubtile.writeToPacketNBT(cmp);
        }
    }

    public void readFromPacketNBT(NBTTagCompound cmp) {
        if (this.subtile != null) {
            this.subtile.readFromPacketNBT(cmp);
        } else {
            this.customSubtile.readFromPacketNBT(cmp);
        }
    }

    public void setSupertile(TileMultiFlower tile) {
        if (this.subtile != null) {
            this.subtile.setSupertile((TileEntity)tile);
        } else {
            this.customSubtile.setSupertile(tile);
        }
    }

    public void onUpdate() {
        if (this.subtile != null) {
            this.subtile.onUpdate();
        } else {
            this.customSubtile.onUpdate();
        }
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        if (this.subtile != null) {
            this.subtile.onBlockPlacedBy(world, x, y, z, entity, stack);
        } else {
            this.customSubtile.onBlockPlacedBy(world, x, y, z, entity, stack);
        }
    }

    public void onBlockAdded(World world, int x, int y, int z) {
        if (this.subtile != null) {
            this.subtile.onBlockAdded(world, x, y, z);
        } else {
            this.customSubtile.onBlockAdded(world, x, y, z);
        }
    }

    public void onBlockHarvested(World world, int x, int y, int z, int side, EntityPlayer player) {
        if (this.subtile != null) {
            this.subtile.onBlockHarvested(world, x, y, z, side, player);
        } else {
            this.customSubtile.onBlockHarvested(world, x, y, z, side, player);
        }
    }

    public void bindTo(EntityPlayer player, ItemStack wand, int x, int y, int z, int side) {
        if (this.subtile != null) {
            this.subtile.bindTo(player, wand, x, y, z, side);
        } else {
            this.customSubtile.bindTo(player, wand, x, y, z, side);
        }
    }

    public void setOvergrowth(boolean b) {
        if (this.subtile != null) {
            this.subtile.overgrowth = b;
        }
    }
}

