/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.draconicevolution;

import by.fxg.basicfml.configv2.BasicPartedConfigPart;
import by.fxg.basicfml.configv2.intermediary.IntermediaryArray;
import by.fxg.basicfml.configv2.intermediary.IntermediaryCompound;
import by.fxg.basicfml.configv2.intermediary.IntermediaryPrimitiveString;
import by.fxg.basicfml.configv2.intermediary.IntermediaryWrapper;
import by.fxg.basicfml.util.BlockCoord;
import java.util.ArrayList;
import java.util.List;

public class ContentDraconicEvolutionConfig
implements BasicPartedConfigPart<IntermediaryCompound> {
    public static final BlockCoord[] NEIGHBOR_BLOCKS_OFFSETS = new BlockCoord[]{BlockCoord.of((int)-1, (int)0, (int)0), BlockCoord.of((int)1, (int)0, (int)0), BlockCoord.of((int)0, (int)-1, (int)0), BlockCoord.of((int)0, (int)1, (int)0), BlockCoord.of((int)0, (int)0, (int)-1), BlockCoord.of((int)0, (int)0, (int)1)};
    public static boolean ENABLED = true;
    public static boolean ENABLE_blockEnergyTransceiver = true;
    public static boolean ENABLE_blockAutoKillerStuff = true;
    public static int AUTOKILLER_SELFCHECK = 300;
    public static int AUTOKILLER_SPAWNRATE_MIN = 20;
    public static int AUTOKILLER_SPAWNRATE_MAX = 200;
    public static int AUTOKILLER_SPAWNRATE_MOD = 15;
    public static int AUTOKILLER_XPCONTAINER_LEVELS = 100;
    public static int AUTOKILLER_MAX_CONNECTIONS = 6;
    public static float AUTOKILLER_ENDERDRAGON_HEART_CHANCE = -1.0f;
    public static float AUTOKILLER_ENDERDRAGON_FRAGMENT_CHANCE = -1.0f;
    public static List<String> AUTOKILLER_BLACKLISTED_ENTITIES = new ArrayList<String>();

    public String getPartName() {
        return "DraconicEvolution";
    }

    public IntermediaryCompound serializePart() {
        IntermediaryCompound compound = new IntermediaryCompound();
        compound.append("enable", ENABLED, "\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0438\u043d\u0442\u0435\u0433\u0440\u0430\u0446\u0438\u044e");
        IntermediaryCompound content = new IntermediaryCompound();
        content.append("blockEnergyTransceiver", ENABLE_blockEnergyTransceiver);
        content.append("blockAutoKillerStuff", ENABLE_blockAutoKillerStuff);
        compound.append("content", (IntermediaryWrapper)content, "\u0412\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435/\u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u0430");
        IntermediaryCompound balance = new IntermediaryCompound();
        IntermediaryCompound autokiller = new IntermediaryCompound();
        autokiller.append("selfcheck_rate", (Number)AUTOKILLER_SELFCHECK, "\u0422\u0438\u043a\u0440\u0435\u0439\u0442 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0432\u0430\u043b\u0438\u0434\u043d\u043e\u0441\u0442\u0438 \u0441\u043f\u0430\u0432\u043d\u0435\u0440\u043e\u0432 \u0438 \u0430\u0432\u0442\u043e\u043a\u0438\u043b\u043b\u0435\u0440\u043e\u0432 \u043d\u0430 \u0441\u043b\u0443\u0447\u0430\u0439 \u043e\u0448\u0438\u0431\u043e\u043a");
        autokiller.append("spawnrate_min", (Number)AUTOKILLER_SPAWNRATE_MIN, "\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0442\u0438\u043a\u0440\u0435\u0439\u0442, \u0441\u0430\u043c\u0430\u044f \u0432\u044b\u0441\u043e\u043a\u0430\u044f \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0441\u043f\u0430\u0432\u043d\u0430");
        autokiller.append("spawnrate_max", (Number)AUTOKILLER_SPAWNRATE_MAX, "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0442\u0438\u043a\u0440\u0435\u0439\u0442, \u0441\u0430\u043c\u0430\u044f \u043c\u0435\u0434\u043b\u0435\u043d\u043d\u0430\u044f \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0441\u043f\u0430\u0432\u043d\u0430");
        autokiller.append("spawnrate_mod", (Number)AUTOKILLER_SPAWNRATE_MOD, "\u041c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0441\u043a\u043e\u0440\u0435\u043d\u0438\u044f \u0441\u043f\u0430\u0432\u043d\u0440\u0435\u0439\u0442\u0430, \u043f\u0435\u0440\u0435\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u043f\u043e: (min + (max - min) - mod * SHARPNESS_LVL)");
        autokiller.append("xpcontainer_levels", (Number)AUTOKILLER_XPCONTAINER_LEVELS, "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u043b\u0432\u043b \u043e\u043f\u044b\u0442\u0430 \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0432\u043c\u0435\u0449\u0430\u0435\u0442 \u0432 \u0441\u0435\u0431\u044f \u0430\u0432\u0442\u043e\u043a\u0438\u043b\u043b\u0435\u0440");
        autokiller.append("max_connections", (Number)AUTOKILLER_MAX_CONNECTIONS, "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b-\u0432\u043e \u0441\u043f\u0430\u0432\u043d\u0435\u0440\u043e\u0432 \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u044b \u043a \u0430\u0432\u0442\u043e\u043a\u0438\u043b\u043b\u0435\u0440\u0443");
        autokiller.append("drop_chance_dragon_heart", (Number)Float.valueOf(AUTOKILLER_ENDERDRAGON_HEART_CHANCE), "\u0428\u0430\u043d\u0441 \u0432\u044b\u043f\u0430\u0434\u0435\u043d\u0438\u044f \u0441\u0435\u0440\u0434\u0446\u0430 \u0434\u0440\u0430\u043a\u043e\u043d\u0430 \u0438\u0437 \u0434\u0440\u0430\u043a\u043e\u043d\u0438\u043a\u0430, -1 \u0434\u043b\u044f \u0442\u043e\u0433\u043e \u0447\u0442\u043e-\u0431\u044b \u043d\u0435 \u0441\u043f\u0430\u0432\u043d\u0438\u043b\u043e\u0441\u044c");
        autokiller.append("drop_chance_dragon_fragment", (Number)Float.valueOf(AUTOKILLER_ENDERDRAGON_FRAGMENT_CHANCE), "\u0428\u0430\u043d\u0441 \u0432\u044b\u043f\u0430\u0434\u0435\u043d\u0438\u044f \u0444\u0440\u0430\u0433\u043c\u0435\u043d\u0442\u0430 \u0438\u0437 \u0434\u0440\u0430\u043a\u043e\u043d\u0438\u043a\u0430, -1 \u0434\u043b\u044f \u0442\u043e\u0433\u043e \u0447\u0442\u043e-\u0431\u044b \u043d\u0435 \u0441\u043f\u0430\u0432\u043d\u0438\u043b\u043e\u0441\u044c");
        IntermediaryArray blacklistedEntities = new IntermediaryArray();
        AUTOKILLER_BLACKLISTED_ENTITIES.forEach(arg_0 -> ((IntermediaryArray)blacklistedEntities).append(arg_0));
        autokiller.append("blacklisted_entities", (IntermediaryWrapper)blacklistedEntities, "\u0421\u0443\u0449\u043d\u043e\u0441\u0442\u0438 \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0442\u044c \u0430\u0432\u0442\u043e-\u043a\u0438\u043b\u043b\u0435\u0440");
        balance.append("autokiller", (IntermediaryWrapper)autokiller, "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0430\u0432\u0442\u043e\u043a\u0438\u043b\u043b\u0435\u0440\u0430");
        compound.append("balance", (IntermediaryWrapper)balance, "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0431\u0430\u043b\u0430\u043d\u0441\u0430");
        return compound;
    }

    public boolean deserializePart(IntermediaryCompound compound) {
        if (compound != null) {
            IntermediaryCompound autokiller;
            IntermediaryCompound balance;
            ENABLED = compound.getBoolean("enable", ENABLED);
            IntermediaryCompound content = compound.getCompound("content");
            if (content != null) {
                ENABLE_blockEnergyTransceiver = content.getBoolean("blockEnergyTransceiver", ENABLE_blockEnergyTransceiver);
                ENABLE_blockAutoKillerStuff = content.getBoolean("blockAutoKillerStuff", ENABLE_blockAutoKillerStuff);
            }
            if ((balance = compound.getCompound("balance")) != null && (autokiller = balance.getCompound("autokiller")) != null) {
                AUTOKILLER_SELFCHECK = autokiller.getInteger("selfcheck_rate", AUTOKILLER_SELFCHECK);
                AUTOKILLER_SPAWNRATE_MIN = autokiller.getInteger("spawnrate_min", AUTOKILLER_SPAWNRATE_MIN);
                AUTOKILLER_SPAWNRATE_MAX = autokiller.getInteger("spawnrate_max", AUTOKILLER_SPAWNRATE_MAX);
                AUTOKILLER_SPAWNRATE_MOD = autokiller.getInteger("spawnrate_mod", AUTOKILLER_SPAWNRATE_MOD);
                AUTOKILLER_XPCONTAINER_LEVELS = Math.max(1, autokiller.getInteger("xpcontainer_levels", AUTOKILLER_XPCONTAINER_LEVELS));
                AUTOKILLER_MAX_CONNECTIONS = autokiller.getInteger("max_connections", AUTOKILLER_MAX_CONNECTIONS);
                AUTOKILLER_ENDERDRAGON_HEART_CHANCE = autokiller.getFloat("drop_chance_dragon_heart", AUTOKILLER_ENDERDRAGON_HEART_CHANCE);
                AUTOKILLER_ENDERDRAGON_FRAGMENT_CHANCE = autokiller.getFloat("drop_chance_dragon_fragment", AUTOKILLER_ENDERDRAGON_FRAGMENT_CHANCE);
                IntermediaryArray arr = autokiller.getArray("blacklisted_entities");
                AUTOKILLER_BLACKLISTED_ENTITIES.clear();
                if (arr != null) {
                    for (IntermediaryWrapper intermediaryWrapper : arr) {
                        if (!intermediaryWrapper.isPrimitive()) continue;
                        String str = ((IntermediaryPrimitiveString)intermediaryWrapper).getString();
                        AUTOKILLER_BLACKLISTED_ENTITIES.add(str);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

