/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.draconicevolution.tile;

import by.fxg.mwintegration.common.ContentConfig;
import com.brandon3055.draconicevolution.common.tileentities.energynet.TileEnergyTransceiver;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.core.IC2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import ru.justagod.cutter.invoke.Invoke;

public class TileAdvEnergyTransceiver
extends TileEnergyTransceiver
implements IEnergySource,
IEnergySink {
    public boolean addedToEnergyNet;
    public boolean loaded;
    public boolean initialized;

    public TileAdvEnergyTransceiver() {
    }

    public TileAdvEnergyTransceiver(int powerTier) {
        super(powerTier);
    }

    public void onLoaded() {
        Invoke.server(() -> {});
        this.loaded = true;
    }

    public void onUnloaded() {
        Invoke.server(() -> {});
        this.loaded = false;
    }

    public void intialize() {
        this.initialized = true;
        if (!this.addedToEnergyNet) {
            this.onLoaded();
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.initialized && this.field_145850_b != null) {
            this.intialize();
        }
    }

    public void onBlockActivated(EntityPlayer player) {
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        }
        if (IC2.platform.isRendering()) {
            IC2.audioManager.removeSources((Object)this);
        }
        super.onBlockActivated(player);
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.func_145837_r() && this.field_145850_b.func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.onLoaded();
        }
    }

    public void func_145843_s() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public void drawEnergy(double v) {
        this.storage.modifyEnergyStored(-((int)(v * (double)ContentConfig.ENERGY_RF_PER_EU)));
    }

    public double injectEnergy(ForgeDirection forgeDirection, double amount, double voltage) {
        double canInject = Math.max(Math.min(this.getDemandedEnergy(), amount), 0.0);
        this.storage.modifyEnergyStored((int)(canInject * (double)ContentConfig.ENERGY_RF_PER_EU));
        return amount - canInject;
    }

    public boolean emitsEnergyTo(TileEntity tileEntity, ForgeDirection forgeDirection) {
        return forgeDirection == ForgeDirection.getOrientation((int)this.facing).getOpposite() && !this.getInput();
    }

    public boolean acceptsEnergyFrom(TileEntity tileEntity, ForgeDirection forgeDirection) {
        return forgeDirection == ForgeDirection.getOrientation((int)this.facing).getOpposite() && this.getInput();
    }

    public double getOfferedEnergy() {
        return Math.max((float)this.storage.getEnergyStored() / ContentConfig.ENERGY_RF_PER_EU, 0.0f);
    }

    public double getDemandedEnergy() {
        return Math.max(0.0f, (float)(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()) / ContentConfig.ENERGY_RF_PER_EU);
    }

    public int getSourceTier() {
        return 4;
    }

    public int getSinkTier() {
        return 4;
    }

    public int getCap() {
        return this.powerTier == 0 ? 20000000 : 40000000;
    }

    public int getRec() {
        return this.powerTier == 0 ? 20000000 : 40000000;
    }

    public int getExt() {
        return this.powerTier == 0 ? 20000000 : 40000000;
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    public int getMaxConnections() {
        return this.powerTier == 0 ? 2 : 4;
    }
}

