/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwicontent.thaumcraft.util;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public final class AspectArray
extends AspectList {
    private static final String ASPECTS = "Aspects";
    private static final String K = "K";
    private static final String V = "V";

    public Aspect getFirstAvailableAspect() {
        for (Aspect aspect : this.aspects.keySet()) {
            Integer amount = (Integer)this.aspects.get(aspect);
            if (aspect == null || amount == null || amount <= 0) continue;
            return aspect;
        }
        return null;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.aspects.clear();
        if (tag.func_74764_b(ASPECTS)) {
            NBTTagList list = tag.func_150295_c(ASPECTS, 10);
            for (int idx = 0; idx < list.func_74745_c(); ++idx) {
                NBTTagCompound cmp = list.func_150305_b(idx);
                if (!cmp.func_74764_b(K)) continue;
                this.add(Aspect.getAspect((String)cmp.func_74779_i(K)), cmp.func_74762_e(V));
            }
        }
    }

    public void readFromNBT(NBTTagCompound tag, String tagName) {
        this.aspects.clear();
        if (tag.func_74764_b(ASPECTS)) {
            NBTTagList list = tag.func_150295_c(tagName, 10);
            for (int idx = 0; idx < list.func_74745_c(); ++idx) {
                NBTTagCompound cmp = list.func_150305_b(idx);
                if (!cmp.func_74764_b(K)) continue;
                this.add(Aspect.getAspect((String)cmp.func_74779_i(K)), cmp.func_74762_e(V));
            }
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (Aspect aspect : this.aspects.keySet()) {
            Integer size = (Integer)this.aspects.get(aspect);
            if (aspect == null || size == null || size <= 0) continue;
            NBTTagCompound cmp = new NBTTagCompound();
            cmp.func_74778_a(K, aspect.getTag());
            cmp.func_74768_a(V, size.intValue());
            list.func_74742_a((NBTBase)cmp);
        }
        tag.func_74782_a(ASPECTS, (NBTBase)list);
    }

    public void writeToNBT(NBTTagCompound tag, String tagName) {
        NBTTagList list = new NBTTagList();
        for (Aspect aspect : this.aspects.keySet()) {
            Integer size = (Integer)this.aspects.get(aspect);
            if (aspect == null || size == null || size <= 0) continue;
            NBTTagCompound cmp = new NBTTagCompound();
            cmp.func_74778_a(K, aspect.getTag());
            cmp.func_74768_a(V, size.intValue());
            list.func_74742_a((NBTBase)cmp);
        }
        tag.func_74782_a(tagName, (NBTBase)list);
    }
}

