/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.mwintegration;

import by.fxg.basicfml.configv2.BasicPartedConfigPart;
import by.fxg.basicfml.configv2.ConfigWrappedParted;
import by.fxg.basicfml.configv2.io.BasicConfigReader;
import by.fxg.basicfml.configv2.io.yaml.YamlIntermediaryReadWriter;
import by.fxg.basicfml.util.IProxy;
import by.fxg.mwintegration.common.ContentConfig;
import by.fxg.mwintegration.common.ContentManager;
import by.fxg.mwintegration.common.GuiHandler;
import by.fxg.mwintegration.common.network.PacketWiredGuiContainer;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="mwi", name="MW-Integration", version="0.0.0", dependencies="required-after:BasicFML;after:CoFHCore;after:appliedenergistics2;after:Avaritia;after:Botania;after:DraconicEvolution;after:Forestry;after:IC2;after:magicalcrops;after:Thaumcraft;after:MineTweaker3;after:NotEnoughItems;after:Waila;after:industrialupgrade;")
public class MWIntegration {
    public static final String MODID = "mwi";
    public static final String MODNAME = "MW-Integration";
    public static final String MODVERSION = "0.0.0";
    public static final String MODDEPENDENCIES = "required-after:BasicFML;after:CoFHCore;after:appliedenergistics2;after:Avaritia;after:Botania;after:DraconicEvolution;after:Forestry;after:IC2;after:magicalcrops;after:Thaumcraft;after:MineTweaker3;after:NotEnoughItems;after:Waila;after:industrialupgrade;";
    @Mod.Instance(value="mwi")
    public static MWIntegration INSTANCE;
    @SidedProxy(clientSide="by.fxg.mwintegration.client.ClientProxy", serverSide="by.fxg.mwintegration.server.ServerProxy")
    public static IProxy PROXY;
    public static Logger LOGGER;
    public static SimpleNetworkWrapper NETWORK;
    protected ConfigWrappedParted configuration;
    protected ContentManager contentManager;
    protected boolean isConfigLoaded = false;

    @Mod.EventHandler
    public void onPreInitialization(FMLPreInitializationEvent event) {
        INSTANCE = this;
        LOGGER = event.getModLog();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)new GuiHandler());
        NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        NETWORK.registerMessage(PacketWiredGuiContainer.Handler.class, PacketWiredGuiContainer.class, 1, Side.CLIENT);
        NETWORK.registerMessage(PacketWiredGuiContainer.Handler.class, PacketWiredGuiContainer.class, 2, Side.SERVER);
        this.configuration = new ConfigWrappedParted(event.getSuggestedConfigurationFile());
        this.configuration.setReadWriter((BasicConfigReader)new YamlIntermediaryReadWriter());
        this.configuration.setSaveOnReadFailure(false);
        this.configuration.register(MODID);
        this.configuration.registerPart((BasicPartedConfigPart)new ContentConfig());
        PROXY.onPreInitialization(event);
    }

    @Mod.EventHandler
    public void onInitialization(FMLInitializationEvent event) {
        this.contentManager = new ContentManager(this.configuration);
        this.isConfigLoaded = this.configuration.load();
        this.contentManager.getIntegrations().forEach(obj -> obj.onInitialization(this.contentManager, event));
        PROXY.onInitialization(event);
    }

    @Mod.EventHandler
    public void onPostInitialization(FMLPostInitializationEvent event) {
        this.contentManager.getIntegrations().forEach(obj -> obj.onPostInitialization(this.contentManager, event));
        PROXY.onPostInitialization(event);
        if (!this.isConfigLoaded) {
            if (!this.configuration.save()) {
                throw new IllegalStateException("MW-Integration is unable to save configuration file.");
            }
            LOGGER.error("MW-Integration configuration file is corrupted and unable to be loaded!");
            this.isConfigLoaded = true;
        }
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        this.contentManager.getIntegrations().forEach(obj -> obj.onServerAboutToStart(this.contentManager, event));
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        this.contentManager.getIntegrations().forEach(obj -> obj.onServerStarting(this.contentManager, event));
        PROXY.onServerStarting(event);
    }

    public ContentManager getContentManager() {
        return this.contentManager;
    }
}

