/*
 * Decompiled with CFR 0.152.
 */
package mantle.lib.environment;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import mantle.crash.CallableSuppConfig;
import mantle.crash.CallableUnsuppConfig;
import mantle.lib.CoreConfig;
import mantle.lib.CoreRepo;

public class EnvironmentChecks {
    public static boolean hasOptifine = false;

    private EnvironmentChecks() {
    }

    public static void verifyEnvironmentSanity() {
        Object callable;
        ArrayList<String> modIds = new ArrayList<String>();
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT && FMLClientHandler.instance().hasOptifine() || Loader.isModLoaded((String)"optifine")) {
            if (!CoreConfig.silenceEnvChecks) {
                CoreRepo.logger.error("[Environment Checks] Optifine detected. This may cause issues due to base edits or ASM usage.");
            }
            hasOptifine = true;
            modIds.add("optifine");
        }
        try {
            Class<?> cl = Class.forName("org.bukkit.Bukkit");
            if (cl != null) {
                if (!CoreConfig.silenceEnvChecks) {
                    CoreRepo.logger.error("[Environment Checks] Bukkit implementation detected. This may cause issues. Bukkit implementations include Craftbukkit and Cauldron(MCPC+).");
                }
                modIds.add("bukkit");
            }
        }
        catch (Exception cl) {
            // empty catch block
        }
        if (modIds.size() == 0) {
            callable = new CallableSuppConfig("Mantle");
            FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)callable);
        } else {
            callable = new CallableUnsuppConfig("Mantle", modIds);
            FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)callable);
        }
    }
}

