/*
 * Decompiled with CFR 0.152.
 */
package mantle.pulsar.control;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import mantle.pulsar.config.IConfiguration;
import mantle.pulsar.internal.Configuration;
import mantle.pulsar.internal.logging.ILogger;
import mantle.pulsar.internal.logging.LogManager;
import mantle.pulsar.pulse.Handler;
import mantle.pulsar.pulse.IPulse;
import mantle.pulsar.pulse.Pulse;
import mantle.pulsar.pulse.PulseMeta;
import mantle.pulsar.pulse.PulseProxy;

public class PulseManager {
    private final ILogger log;
    private final boolean useConfig;
    private final LinkedHashMap<Object, PulseMeta> pulses = new LinkedHashMap();
    private boolean blockNewRegistrations = false;
    private boolean configLoaded = false;
    private IConfiguration conf;

    @Deprecated
    public PulseManager(String modId) {
        this.log = LogManager.getLogger("PulseManager-" + modId);
        this.useConfig = false;
        this.conf = null;
    }

    public PulseManager(String modId, String configName) {
        this.log = LogManager.getLogger("PulseManager-" + modId);
        this.useConfig = true;
        this.conf = new Configuration(configName, this.log);
    }

    public PulseManager(String modId, IConfiguration config) {
        this.log = LogManager.getLogger("PulseManager-" + modId);
        this.useConfig = true;
        this.conf = config;
    }

    public void registerPulse(Object pulse) {
        boolean enabled;
        boolean forced;
        String deps;
        String description;
        String id;
        if (this.blockNewRegistrations) {
            throw new RuntimeException("A mod tried to register a plugin after preinit! Pulse: " + pulse);
        }
        if (!this.configLoaded) {
            this.conf.load();
            this.configLoaded = true;
        }
        boolean missingDeps = false;
        try {
            Pulse p = pulse.getClass().getAnnotation(Pulse.class);
            id = p.id();
            description = p.description();
            deps = p.modsRequired();
            forced = p.forced();
            enabled = p.defaultEnable();
        }
        catch (NullPointerException ex) {
            throw new RuntimeException("Could not parse @Pulse annotation for Pulse: " + pulse);
        }
        if (description.equals("")) {
            description = null;
        }
        if (!deps.equals("")) {
            String[] parsedDeps;
            for (String s : parsedDeps = deps.split(";")) {
                if (Loader.isModLoaded((String)s)) continue;
                this.log.info("Skipping Pulse " + id + "; missing dependency: " + s);
                missingDeps = true;
                enabled = false;
                break;
            }
        }
        PulseMeta meta = new PulseMeta(id, description, forced, enabled);
        meta.setEnabled(!missingDeps && this.getEnabledFromConfig(meta));
        if (meta.isEnabled()) {
            this.parseAndAddProxies(pulse);
            this.pulses.put(pulse, meta);
        }
    }

    private boolean getEnabledFromConfig(PulseMeta meta) {
        if (meta.isForced() || !this.useConfig) {
            return true;
        }
        return this.conf.isModuleEnabled(meta);
    }

    @Deprecated
    private void parseAndAddProxies(Object pulse) {
        try {
            for (Field f : pulse.getClass().getDeclaredFields()) {
                this.log.debug("Parsing field: " + f);
                PulseProxy p = f.getAnnotation(PulseProxy.class);
                if (p == null) continue;
                this.log.warn("Pulse " + pulse + " used the deprecated PulseProxy annotation. As of Pulsar 0.1.0, it's now preferred to use FML's SidedProxy annotation.");
                this.log.warn("The old PulseProxy parsing will be removed in the next breaking update (Pulsar 1.x).");
                this.setProxyField(pulse, f, p.clientSide(), p.serverSide());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Pulse annotation parsing failed for Pulse " + pulse + "; " + ex);
        }
    }

    @Deprecated
    private void setProxyField(Object pulse, Field f, String client, String server) throws Exception {
        boolean accessible = f.isAccessible();
        f.setAccessible(true);
        switch (FMLCommonHandler.instance().getSide()) {
            case CLIENT: {
                f.set(pulse, Class.forName(client).newInstance());
                break;
            }
            default: {
                f.set(pulse, Class.forName(server).newInstance());
            }
        }
        f.setAccessible(accessible);
    }

    public void preInit(FMLPreInitializationEvent evt) {
        if (!this.blockNewRegistrations) {
            this.conf.flush();
        }
        this.blockNewRegistrations = true;
        for (Map.Entry<Object, PulseMeta> e : this.pulses.entrySet()) {
            if (!this.hasRequiredPulses(e)) continue;
            this.log.debug("Preinitialising Pulse " + e.getValue().getId() + "...");
            if (e.getKey() instanceof IPulse) {
                IPulse ip = (IPulse)e.getKey();
                ip.preInit(evt);
                continue;
            }
            this.findAndInvokeHandlers(e.getKey(), evt);
        }
    }

    public void init(FMLInitializationEvent evt) {
        for (Map.Entry<Object, PulseMeta> e : this.pulses.entrySet()) {
            this.log.debug("Initialising Pulse " + e.getValue().getId() + "...");
            if (e.getKey() instanceof IPulse) {
                IPulse ip = (IPulse)e.getKey();
                ip.init(evt);
                this.log.warn("Pulse " + e.getValue().getId() + " is using the deprecated IPulse interface.");
                this.log.warn("This will be removed in the next major version (Pulsar 1.x) - Please switch to @Handler!");
                continue;
            }
            this.findAndInvokeHandlers(e.getKey(), evt);
        }
    }

    public void postInit(FMLPostInitializationEvent evt) {
        for (Map.Entry<Object, PulseMeta> e : this.pulses.entrySet()) {
            this.log.debug("Postinitialising Pulse " + e.getValue().getId() + "...");
            if (e.getKey() instanceof IPulse) {
                IPulse ip = (IPulse)e.getKey();
                ip.postInit(evt);
                continue;
            }
            this.findAndInvokeHandlers(e.getKey(), evt);
        }
    }

    private void findAndInvokeHandlers(Object pulse, Object evt) {
        for (Method m : pulse.getClass().getDeclaredMethods()) {
            try {
                Class<?> pt;
                Class<?>[] pTypes;
                if (m.getAnnotation(Handler.class) == null || (pTypes = m.getParameterTypes()).length != 1 || !(pt = pTypes[0]).isAssignableFrom(evt.getClass())) continue;
                m.invoke(pulse, evt);
            }
            catch (Exception ex) {
                this.log.warn("Caught exception in findAndInvokeHandlers: " + ex);
                ex.printStackTrace();
            }
        }
    }

    private boolean hasRequiredPulses(Map.Entry<Object, PulseMeta> entry) {
        String deps = entry.getKey().getClass().getAnnotation(Pulse.class).pulsesRequired();
        if (!deps.equals("")) {
            String[] parsedDeps;
            for (String s : parsedDeps = deps.split(";")) {
                if (this.isPulseLoaded(s)) continue;
                this.log.info("Skipping Pulse " + entry.getValue().getId() + "; missing pulse: " + s);
                return false;
            }
        }
        return true;
    }

    public boolean isPulseLoaded(String pulseId) {
        for (Map.Entry<Object, PulseMeta> entry : this.pulses.entrySet()) {
            if (!entry.getValue().getId().equals(pulseId)) continue;
            return true;
        }
        return false;
    }
}

