/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.modernbus;

import by.fxg.modernbus.Mail;
import by.fxg.modernbus.MailSubscription;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ModernBus {
    private static final Map<Class<? extends Mail>, List<MailSubscription>> mailRegistry = new HashMap<Class<? extends Mail>, List<MailSubscription>>();

    @Deprecated
    public static <MAIL extends Mail> void register$(MailSubscription<MAIL> ... subscriptions) {
        for (MailSubscription<MAIL> subscription : subscriptions) {
            ModernBus.register(subscription);
        }
    }

    @Deprecated
    public static <MAIL extends Mail> void register(@Nonnull MailSubscription<MAIL> subscription) {
        Objects.requireNonNull(subscription, "Subscription object can't be null");
        ParameterizedType type = (ParameterizedType)subscription.getClass().getGenericSuperclass();
        ModernBus.register((Class)type.getActualTypeArguments()[0], subscription);
    }

    public static <MAIL extends Mail> void register(@Nonnull Class<MAIL> type, @Nonnull MailSubscription<MAIL> subscription) {
        Objects.requireNonNull(type, "Type can't be null");
        Objects.requireNonNull(subscription, "Subscription object can't be null");
        if (!mailRegistry.containsKey(type)) {
            mailRegistry.put(type, new ArrayList());
        }
        if (!mailRegistry.get(type).contains(subscription)) {
            mailRegistry.get(type).add(subscription);
        }
    }

    @Deprecated
    public static void registerAll(MailSubscription<? extends Mail> ... subscriptions) {
        for (MailSubscription<? extends Mail> subscription : subscriptions) {
            ModernBus.register(subscription);
        }
    }

    @Deprecated
    public static <MAIL extends Mail> void unregister(MailSubscription<MAIL> ... subscriptions) {
        for (MailSubscription<MAIL> subscription : subscriptions) {
            ModernBus.unregister(subscription);
        }
    }

    @Deprecated
    public static <MAIL extends Mail> boolean unregister(@Nonnull MailSubscription<MAIL> subscription) {
        Objects.requireNonNull(subscription, "Subscription object can't be null");
        ParameterizedType type = (ParameterizedType)subscription.getClass().getGenericSuperclass();
        return ModernBus.unregister((Class)type.getActualTypeArguments()[0], subscription);
    }

    public static <MAIL extends Mail> boolean unregister(@Nonnull Class<MAIL> type, @Nullable MailSubscription<MAIL> subscription) {
        if (mailRegistry.containsKey(type)) {
            return mailRegistry.get(type).remove(subscription);
        }
        return false;
    }

    public static <MAIL extends Mail> MAIL post(@Nonnull MAIL mail) {
        List<MailSubscription> subscriptions = mailRegistry.get(mail.getClass());
        if (subscriptions != null) {
            subscriptions.forEach(subscription -> subscription.onMail(mail));
        }
        return mail;
    }

    public static <MAIL extends Mail> void postUnsafeAsync(@Nonnull MAIL mail, @Nullable Consumer<MAIL> completionCallback) {
        CompletableFuture.runAsync(() -> {
            List<MailSubscription> subscriptions = mailRegistry.get(mail.getClass());
            if (subscriptions != null) {
                subscriptions.forEach(subscription -> subscription.onMail(mail));
            }
            if (completionCallback != null) {
                completionCallback.accept(mail);
            }
        });
    }

    public static <MAIL extends Mail> void postAsync(@Nonnull MAIL mail, @Nullable Consumer<MAIL> completionCallback) {
        List<MailSubscription> subscriptions = mailRegistry.get(mail.getClass());
        if (subscriptions != null) {
            CompletableFuture.runAsync(() -> {
                ArrayList internalSubscriptions = new ArrayList(subscriptions);
                internalSubscriptions.forEach(subscription -> subscription.onMail(mail));
                if (completionCallback != null) {
                    completionCallback.accept(mail);
                }
            });
        } else if (completionCallback != null) {
            completionCallback.accept(mail);
        }
    }
}

