/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.pluginforgery;

import by.fxg.modernbus.MailSubscription;
import by.fxg.modernbus.ModernBus;
import by.fxg.pluginforgery.api.IForgeryAPI;
import by.fxg.pluginforgery.api.RetrieveMail;
import by.fxg.pluginforgery.api.chat.IForgeryChat;
import by.fxg.pluginforgery.api.economy.IForgeryEconomy;
import by.fxg.pluginforgery.api.essentials.IForgeryEssentials;
import by.fxg.pluginforgery.api.ow.IForgeryOnlineWatcher;
import by.fxg.pluginforgery.api.permission.IForgeryPermissions;
import by.fxg.pluginforgery.api.player.IForgeryPlayer;
import by.fxg.pluginforgery.api.regions.IForgeryRegions;

public class ForgeryAPI
implements IForgeryAPI {
    public static ForgeryAPI INSTANCE;
    public IForgeryPermissions permissions = null;
    public IForgeryEconomy economy = null;
    public IForgeryChat chat = null;
    public IForgeryRegions regions = null;
    public IForgeryOnlineWatcher onlineWatcher = null;
    public IForgeryEssentials essentials = null;
    public IForgeryPlayer player = null;
    private MailSubscription<RetrieveMail.RetrieveAPI> retrieveAPI;
    private MailSubscription<RetrieveMail.RetrievePermissions> retrievePermissions;
    private MailSubscription<RetrieveMail.RetrieveEconomy> retrieveEconomy;
    private MailSubscription<RetrieveMail.RetrieveChat> retrieveChat;
    private MailSubscription<RetrieveMail.RetrieveRegions> retrieveRegions;
    private MailSubscription<RetrieveMail.RetrievePlayer> retrievePlayer;
    private MailSubscription<RetrieveMail.RetrieveOW> retrieveOnlineWatcher;
    private MailSubscription<RetrieveMail.RetrieveEssentials> retrieveEssentials;

    protected ForgeryAPI() {
        INSTANCE = this;
    }

    protected void register() {
        this.retrieveAPI = this::onAPIRequest;
        ModernBus.register(RetrieveMail.RetrieveAPI.class, this.retrieveAPI);
        this.retrievePermissions = this::onPermissionsRequest;
        ModernBus.register(RetrieveMail.RetrievePermissions.class, this.retrievePermissions);
        this.retrieveEconomy = this::onEconomyRequest;
        ModernBus.register(RetrieveMail.RetrieveEconomy.class, this.retrieveEconomy);
        this.retrieveChat = this::onChatRequest;
        ModernBus.register(RetrieveMail.RetrieveChat.class, this.retrieveChat);
        this.retrieveRegions = this::onRegionsRequest;
        ModernBus.register(RetrieveMail.RetrieveRegions.class, this.retrieveRegions);
        this.retrievePlayer = this::onPlayerRequest;
        ModernBus.register(RetrieveMail.RetrievePlayer.class, this.retrievePlayer);
        this.retrieveOnlineWatcher = this::onOWRequest;
        ModernBus.register(RetrieveMail.RetrieveOW.class, this.retrieveOnlineWatcher);
        this.retrieveEssentials = this::onEssRequest;
        ModernBus.register(RetrieveMail.RetrieveEssentials.class, this.retrieveEssentials);
    }

    protected void unregister() {
        ModernBus.unregister(RetrieveMail.RetrieveAPI.class, this.retrieveAPI);
        ModernBus.unregister(RetrieveMail.RetrievePermissions.class, this.retrievePermissions);
        ModernBus.unregister(RetrieveMail.RetrieveEconomy.class, this.retrieveEconomy);
        ModernBus.unregister(RetrieveMail.RetrieveChat.class, this.retrieveChat);
        ModernBus.unregister(RetrieveMail.RetrieveRegions.class, this.retrieveRegions);
        ModernBus.unregister(RetrieveMail.RetrievePlayer.class, this.retrievePlayer);
        ModernBus.unregister(RetrieveMail.RetrieveOW.class, this.retrieveOnlineWatcher);
        ModernBus.unregister(RetrieveMail.RetrieveEssentials.class, this.retrieveEssentials);
    }

    @Override
    public IForgeryEconomy getEconomy() {
        return this.economy;
    }

    @Override
    public IForgeryPermissions getPermissions() {
        return this.permissions;
    }

    @Override
    public IForgeryRegions getRegions() {
        return this.regions;
    }

    @Override
    public IForgeryPlayer getPlayer() {
        return this.player;
    }

    @Override
    public IForgeryOnlineWatcher getOW() {
        return this.onlineWatcher;
    }

    @Override
    public IForgeryEssentials getEssentials() {
        return this.essentials;
    }

    private void onAPIRequest(RetrieveMail.RetrieveAPI mail) {
        if (!mail.has()) {
            mail.set(this);
        }
    }

    private void onPermissionsRequest(RetrieveMail.RetrievePermissions mail) {
        if (!mail.has() && this.permissions != null) {
            mail.set(this.permissions);
        }
    }

    private void onEconomyRequest(RetrieveMail.RetrieveEconomy mail) {
        if (!mail.has() && this.economy != null) {
            mail.set(this.economy);
        }
    }

    private void onChatRequest(RetrieveMail.RetrieveChat mail) {
        if (!mail.has() && this.chat != null) {
            mail.set(this.chat);
        }
    }

    private void onRegionsRequest(RetrieveMail.RetrieveRegions mail) {
        if (!mail.has() && this.regions != null) {
            mail.set(this.regions);
        }
    }

    private void onPlayerRequest(RetrieveMail.RetrievePlayer mail) {
        if (!mail.has() && this.player != null) {
            mail.set(this.player);
        }
    }

    private void onOWRequest(RetrieveMail.RetrieveOW mail) {
        if (!mail.has() && this.onlineWatcher != null) {
            mail.set(this.onlineWatcher);
        }
    }

    private void onEssRequest(RetrieveMail.RetrieveEssentials mail) {
        if (!mail.has() && this.essentials != null) {
            mail.set(this.essentials);
        }
    }
}

